/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest;

import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.wildfly.camel.examples.rest.data.CustomerRepository;
import org.wildfly.camel.examples.rest.model.Customer;

@Startup
@ApplicationScoped
@ContextName(value="rest-camel-context")
public class RestConsumerRouteBuilder
extends RouteBuilder {
    @Inject
    private CustomerRepository customerRepository;

    public void configure() throws Exception {
        this.restConfiguration().component("servlet").contextPath("/camel-example-rest/camel").port(8080).bindingMode(RestBindingMode.json);
        this.rest("/customer").get("/{id}").produces("application/json").to("direct:readCustomer").post().type(Customer.class).to("direct:createCustomer");
        ((RouteDefinition)this.from("direct:readCustomer").bean((Object)this.customerRepository, "readCustomer(${header.id})")).choice().when((Predicate)this.simple("${body} == null")).setHeader("CamelHttpResponseCode", (Expression)this.constant((Object)404));
        this.from("direct:createCustomer").bean((Object)this.customerRepository, "createCustomer");
        this.from("direct:rest").process((Processor)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ CustomerRepository access$000(RestConsumerRouteBuilder x0) {
        return x0.customerRepository;
    }
}

