/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.cxf.jaxws;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.util.jsse.ClientAuthentication;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.SSLContextClientParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.SSLContextServerParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;
import org.apache.cxf.interceptor.security.JAASLoginInterceptor;
import org.apache.cxf.interceptor.security.SimpleAuthorizingInterceptor;
import org.apache.cxf.interceptor.security.callback.CallbackHandlerProvider;
import org.wildfly.camel.examples.cxf.jaxws.Application;
import org.wildfly.camel.examples.cxf.jaxws.GreetingService;
import org.wildfly.camel.examples.cxf.jaxws.GreetingsProcessor;
import org.wildfly.camel.examples.cxf.jaxws.JBossCallbackHandlerTlsCert;

@Named(value="cxf_cdi_security_app")
public class Application {
    private static final String CXF_PRODUCER_ENDPOINT_ADDRESS = "https://localhost:8443/webservices/greeting-secure-cdi";
    private static final String CXF_CONSUMER_ENDPOINT_ADDRESS = "https://localhost:8443/webservices/greeting-secure-cdi";
    private static final String WILDFLY_SECURITY_DOMAIN_NAME = "client-cert";
    private static final String KEYSTORE_PATH = System.getProperty("jboss.server.config.dir") + "/application.keystore";
    private static final String KEYSTORE_PASSWORD = "password";
    private static final String TRUSTSTORE_ALIAS_NAME = "server";
    @Inject
    @ContextName(value="cxfws-security-camel-context")
    CamelContext camelContext;

    @Named(value="greetingsProcessor")
    @Produces
    public Processor produceGreetingsProcessor() {
        return new GreetingsProcessor();
    }

    @Named(value="cxfProducerEndpoint")
    @Produces
    public CxfEndpoint createCxfProducerEndpoint() {
        CxfComponent cxfProducerComponent = new CxfComponent(this.camelContext);
        CxfEndpoint cxfProducerEndpoint = new CxfEndpoint("https://localhost:8443/webservices/greeting-secure-cdi", cxfProducerComponent);
        cxfProducerEndpoint.setBeanId("cxfProducerEndpoint");
        cxfProducerEndpoint.setServiceClass(GreetingService.class);
        SSLContextParameters producerSslContextParameters = this.createProducerSSLContextParameters();
        cxfProducerEndpoint.setSslContextParameters(producerSslContextParameters);
        1 hostnameVerifier = new /* Unavailable Anonymous Inner Class!! */;
        cxfProducerEndpoint.setHostnameVerifier((HostnameVerifier)hostnameVerifier);
        return cxfProducerEndpoint;
    }

    @Named(value="cxfConsumerEndpoint")
    @Produces
    public CxfEndpoint createCxfConsumerEndpoint() {
        CxfComponent cxfConsumerComponent = new CxfComponent(this.camelContext);
        CxfEndpoint cxfConsumerEndpoint = new CxfEndpoint("https://localhost:8443/webservices/greeting-secure-cdi", cxfConsumerComponent);
        cxfConsumerEndpoint.setBeanId("cxfConsumerEndpoint");
        cxfConsumerEndpoint.setServiceClass(GreetingService.class);
        SSLContextParameters consumerSslContextParameters = this.createConsumerSSLContextParameters();
        cxfConsumerEndpoint.setSslContextParameters(consumerSslContextParameters);
        List inInterceptors = cxfConsumerEndpoint.getInInterceptors();
        JAASLoginInterceptor jaasLoginInterceptor = new JAASLoginInterceptor();
        jaasLoginInterceptor.setContextName(WILDFLY_SECURITY_DOMAIN_NAME);
        jaasLoginInterceptor.setAllowAnonymous(false);
        List<CallbackHandlerProvider> chp = Arrays.asList(new JBossCallbackHandlerTlsCert());
        jaasLoginInterceptor.setCallbackHandlerProviders(chp);
        inInterceptors.add(jaasLoginInterceptor);
        SimpleAuthorizingInterceptor authorizingInterceptor = new SimpleAuthorizingInterceptor();
        authorizingInterceptor.setAllowAnonymousUsers(false);
        HashMap<String, String> rolesMap = new HashMap<String, String>(1);
        rolesMap.put("greet", "testRole");
        authorizingInterceptor.setMethodRolesMap(rolesMap);
        inInterceptors.add(authorizingInterceptor);
        return cxfConsumerEndpoint;
    }

    private SSLContextParameters createProducerSSLContextParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource(KEYSTORE_PATH);
        ksp.setPassword(KEYSTORE_PASSWORD);
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword(KEYSTORE_PASSWORD);
        SSLContextClientParameters sslContextClientParameters = new SSLContextClientParameters();
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        sslContextParameters.setClientParameters(sslContextClientParameters);
        sslContextParameters.setKeyManagers(kmp);
        sslContextParameters.setCertAlias(TRUSTSTORE_ALIAS_NAME);
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setKeyStore(ksp);
        sslContextParameters.setTrustManagers(tmp);
        return sslContextParameters;
    }

    private SSLContextParameters createConsumerSSLContextParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource(KEYSTORE_PATH);
        ksp.setPassword(KEYSTORE_PASSWORD);
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setKeyStore(ksp);
        SSLContextServerParameters sslContextServerParameters = new SSLContextServerParameters();
        sslContextServerParameters.setClientAuthentication(ClientAuthentication.REQUIRE.name());
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        sslContextParameters.setServerParameters(sslContextServerParameters);
        sslContextParameters.setTrustManagers(tmp);
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword(KEYSTORE_PASSWORD);
        sslContextParameters.setKeyManagers(kmp);
        return sslContextParameters;
    }
}

