/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.cxf.jaxws;

import java.security.cert.Certificate;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.interceptor.security.callback.CallbackHandlerProvider;
import org.apache.cxf.interceptor.security.callback.CertificateToNameMapper;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.jboss.security.auth.callback.UsernamePasswordHandler;

public class JBossCallbackHandlerTlsCert
implements CallbackHandlerProvider {
    private CertificateToNameMapper certMapper = new /* Unavailable Anonymous Inner Class!! */;

    public CallbackHandler create(Message message) {
        TLSSessionInfo tlsSession = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        if (tlsSession == null) {
            return null;
        }
        Certificate cert = this.getCertificate(message);
        String name = this.certMapper.getUserName(cert);
        return new UsernamePasswordHandler(name, (Object)cert);
    }

    private Certificate getCertificate(Message message) {
        TLSSessionInfo tlsSessionInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        if (tlsSessionInfo == null) {
            throw new SecurityException("Not TLS connection");
        }
        Certificate[] certificates = tlsSessionInfo.getPeerCertificates();
        if (certificates == null || certificates.length == 0) {
            throw new SecurityException("No certificate found");
        }
        return certificates[0];
    }

    public void setCertMapper(CertificateToNameMapper certMapper) {
        this.certMapper = certMapper;
    }
}

