/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.cxf.jaxws;

import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.camel.util.jsse.SSLContextClientParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;
import org.wildfly.camel.examples.cxf.jaxws.Application;
import org.wildfly.camel.examples.cxf.jaxws.GreetingService;
import org.wildfly.camel.examples.cxf.jaxws.GreetingsProcessor;

@Named(value="cxf_cdi_security_app")
public class Application {
    private static final String CLIENT_CERT_KEYSTORE_PASSWORD = "123456";
    private static final String CLIENT_CERT_KEYSTORE_PATH = System.getProperty("jboss.server.config.dir") + "/client.keystore";
    private static final String CLIENT_CERT_TRUSTSTORE_PATH = System.getProperty("jboss.server.config.dir") + "/client.truststore";
    private static final String CXF_ENDPOINT_URI = "cxf:https://localhost:8443/webservices/greeting-secure-cdi";
    @Inject
    @ContextName(value="cxfws-secure-cdi-camel-context")
    CamelContext camelContext;

    @Named(value="cxfConsumerEndpoint")
    @Produces
    public CxfEndpoint createCxfConsumerEndpoint() {
        CxfEndpoint cxfConsumerEndpoint = (CxfEndpoint)this.camelContext.getEndpoint(CXF_ENDPOINT_URI, CxfEndpoint.class);
        cxfConsumerEndpoint.setBeanId("cxfConsumerEndpoint");
        cxfConsumerEndpoint.setServiceClass(GreetingService.class);
        return cxfConsumerEndpoint;
    }

    @Named(value="cxfProducerEndpoint")
    @Produces
    public CxfEndpoint createCxfProducerEndpoint() {
        CxfEndpoint cxfProducerEndpoint = (CxfEndpoint)this.camelContext.getEndpoint(CXF_ENDPOINT_URI, CxfEndpoint.class);
        cxfProducerEndpoint.setBeanId("cxfProducerEndpoint");
        cxfProducerEndpoint.setServiceClass(GreetingService.class);
        SSLContextParameters producerSslContextParameters = this.createProducerSSLContextParameters();
        cxfProducerEndpoint.setSslContextParameters(producerSslContextParameters);
        1 hostnameVerifier = new /* Unavailable Anonymous Inner Class!! */;
        cxfProducerEndpoint.setHostnameVerifier((HostnameVerifier)hostnameVerifier);
        return cxfProducerEndpoint;
    }

    private SSLContextParameters createProducerSSLContextParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource(CLIENT_CERT_KEYSTORE_PATH);
        ksp.setPassword(CLIENT_CERT_KEYSTORE_PASSWORD);
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyStore(ksp);
        kmp.setKeyPassword(CLIENT_CERT_KEYSTORE_PASSWORD);
        SSLContextClientParameters sslContextClientParameters = new SSLContextClientParameters();
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        sslContextParameters.setClientParameters(sslContextClientParameters);
        sslContextParameters.setKeyManagers(kmp);
        sslContextParameters.setCertAlias("client");
        sslContextParameters.setSecureSocketProtocol("TLSv1.2");
        KeyStoreParameters trustStoreParams = new KeyStoreParameters();
        trustStoreParams.setResource(CLIENT_CERT_TRUSTSTORE_PATH);
        trustStoreParams.setPassword(CLIENT_CERT_KEYSTORE_PASSWORD);
        TrustManagersParameters tmp = new TrustManagersParameters();
        tmp.setKeyStore(trustStoreParams);
        sslContextParameters.setTrustManagers(tmp);
        return sslContextParameters;
    }

    @Named(value="greetingsProcessor")
    @Produces
    public Processor produceGreetingsProcessor() {
        return new GreetingsProcessor();
    }
}

