/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.cxf.jaxws;

import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.ImportResource;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.wildfly.camel.examples.cxf.jaxws.GreetingService;
import org.wildfly.camel.examples.cxf.jaxws.GreetingsProcessor;

@Named(value="cxf_cdi_xml_app")
@ImportResource(value={"cxfws-cdi-xml-camel-context.xml"})
public class Application {
    private static final String CXF_ENDPOINT_URI = "cxf:http://localhost:8080/webservices/greeting-cdi-xml";
    @Inject
    @ContextName(value="cxfws-cdi-xml-camel-context")
    CamelContext context;

    @Named(value="greetingsProcessor")
    @Produces
    public Processor createGreetingsProcessor() {
        return new GreetingsProcessor();
    }

    @Named(value="cxfConsumer")
    @Produces
    public CxfEndpoint createCxfConsumer() {
        CxfEndpoint cxfFromEndpoint = (CxfEndpoint)this.context.getEndpoint(CXF_ENDPOINT_URI, CxfEndpoint.class);
        cxfFromEndpoint.setServiceClass(GreetingService.class);
        return cxfFromEndpoint;
    }

    @Named(value="cxfProducer")
    @Produces
    public CxfEndpoint createCxfProducer() {
        CxfEndpoint cxfToEndpoint = (CxfEndpoint)this.context.getEndpoint(CXF_ENDPOINT_URI, CxfEndpoint.class);
        cxfToEndpoint.setServiceClass(GreetingService.class);
        return cxfToEndpoint;
    }
}

