/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class FileConsumingTestSupport {
    @Before
    public void setUp() throws Exception {
        String packageName = this.getClass().getPackage().getName();
        String fileLocation = packageName.replace("org.wildfly.camel.test.", "").replace(".", "/");
        String sourceFileName = this.sourceFilename();
        InputStream input = this.getClass().getResourceAsStream("/" + fileLocation + "/" + sourceFileName);
        Files.copy(input, this.destinationPath().resolve(sourceFileName), new CopyOption[0]);
        input.close();
        boolean await = this.awaitFileProcessed();
        Assert.assertTrue((String)"Gave up waiting for file to be processed", (boolean)await);
    }

    @After
    public void tearDown() throws IOException {
        Files.walkFileTree(this.destinationPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                exception.printStackTrace();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                if (exception == null) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private boolean awaitFileProcessed() throws Exception {
        long start = System.currentTimeMillis();
        long timeout = 15000L;
        do {
            File file;
            if ((file = this.processedPath().toFile()).exists() && (file.isDirectory() && file.list().length > 0 || file.isFile())) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        } while (System.currentTimeMillis() - start < timeout);
        return false;
    }

    protected abstract String sourceFilename();

    protected abstract Path destinationPath();

    protected abstract Path processedPath();
}

