/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.common;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class ServerLogReader {
    private static final Path SERVER_LOG = Paths.get(System.getProperty("jboss.home"), "standalone/log/server.log");

    public static boolean awaitLogMessage(String message, long timeout) {
        long start = System.currentTimeMillis();
        do {
            try {
                List<String> logLines = Files.readAllLines(SERVER_LOG);
                if (logLines.stream().filter(line -> line.matches(message)).count() > 0L) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        } while (System.currentTimeMillis() - start < timeout);
        return false;
    }
}

