/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.cxf;

import java.io.File;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.examples.test.common.UserManager;
import org.wildfly.camel.test.common.http.HttpRequest;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={UserSetup.class})
public class CxfSecureWsExampleTest {
    private static final String ENDPOINT_ADDRESS = "http://localhost:8080/example-camel-cxf-jaxws-secure/cxf/";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-cxf-jaxws-secure.war"));
    }

    @Test
    public void testSayHelloCxfSoapRoute() throws Exception {
        HttpRequest.HttpResponse result = HttpRequest.post((String)ENDPOINT_ADDRESS).header("Content-Type", "application/x-www-form-urlencoded").content("message=Hello&name=Kermit").getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("Hello Kermit"));
    }

    static class UserSetup
    implements ServerSetupTask {
        UserSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            UserManager.addApplicationUser("testUser", "testPassword1+");
            UserManager.addRoleToApplicationUser("testUser", "testRole");
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            UserManager.removeApplicationUser("testUser");
            UserManager.revokeRoleFromApplicationUser("testUser", "testRole");
        }
    }
}

