/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.cxf;

import java.io.File;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.examples.test.common.ServerReload;
import org.wildfly.camel.examples.test.common.UserManager;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.common.utils.DMRUtils;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={ServerSecuritySetup.class})
public class CxfWsCdiSecureExampleTest {
    private static final String HTTPS_HOST = "https://localhost:8443";
    private static final String ENDPOINT_ADDRESS = "http://localhost:8080/example-camel-cxf-jaxws-cdi-secure/cxf/";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-cxf-jaxws-cdi-secure.war"));
    }

    @Test
    public void testSecureCxfSoapRoute() throws Exception {
        HttpRequest.HttpResponse result = HttpRequest.post((String)ENDPOINT_ADDRESS).header("Content-Type", "application/x-www-form-urlencoded").content("message=Hello&name=Kermit").getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("Hello Kermit"));
    }

    static class ServerSecuritySetup
    implements ServerSetupTask {
        private static final String APPLICATION_USER = "CN=localhost";
        private static final String APPLICATION_PASSWORD = "testPassword1+";
        private static final String APPLICATION_ROLE = "testRole";
        private static final String TRUSTSTORE_PASSWORD = "password";
        private static final String TRUSTSTORE_PATH = "${jboss.home.dir}/standalone/configuration/application.keystore";
        private static final String ADDRESS_SYSTEM_PROPERTY_TRUST_STORE_PASSWORD = "system-property=javax.net.ssl.trustStorePassword";
        private static final String ADDRESS_SYSTEM_PROPERTY_TRUST_STORE = "system-property=javax.net.ssl.trustStore";
        private static final String ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CERTIFICATE_TRUST_DOMAIN = "subsystem=security/security-domain=certificate-trust-domain";
        private static final String ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CERTIFICATE_TRUST_DOMAIN_JSSE_CLASSIC = "subsystem=security/security-domain=certificate-trust-domain/jsse=classic";
        private static final String ADDRESS_ATTRIBUTE_TRUSTSTORE = "truststore";
        private static final String ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CLIENT_CERT = "subsystem=security/security-domain=client-cert";
        private static final String ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CLIENT_CERT_AUTH_CLASSIC = "subsystem=security/security-domain=client-cert/authentication=classic";
        private static final String ADDRESS_SUBSYSTEM_UNDERTOW_HTTPS_LISTENER = "subsystem=undertow/server=default-server/https-listener=https";

        ServerSecuritySetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            HttpRequest.post((String)CxfWsCdiSecureExampleTest.HTTPS_HOST).getResponse();
            UserManager.addApplicationUser(APPLICATION_USER, APPLICATION_PASSWORD);
            UserManager.addRoleToApplicationUser(APPLICATION_USER, APPLICATION_ROLE);
            ModelNode[] steps = new ModelNode[8];
            steps[0] = DMRUtils.createOpNode((String)ADDRESS_SYSTEM_PROPERTY_TRUST_STORE, (String)"add");
            steps[0].get("value").set(TRUSTSTORE_PATH);
            steps[1] = DMRUtils.createOpNode((String)ADDRESS_SYSTEM_PROPERTY_TRUST_STORE_PASSWORD, (String)"add");
            steps[1].get("value").set(TRUSTSTORE_PASSWORD);
            steps[2] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CERTIFICATE_TRUST_DOMAIN, (String)"add");
            steps[3] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CERTIFICATE_TRUST_DOMAIN_JSSE_CLASSIC, (String)"add");
            steps[4] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CERTIFICATE_TRUST_DOMAIN_JSSE_CLASSIC, (String)"write-attribute");
            steps[4].get("name").set(ADDRESS_ATTRIBUTE_TRUSTSTORE);
            steps[4].get("value").get(TRUSTSTORE_PASSWORD).set(TRUSTSTORE_PASSWORD);
            steps[4].get("value").get("url").set(TRUSTSTORE_PATH);
            steps[5] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CLIENT_CERT, (String)"add");
            steps[6] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CLIENT_CERT_AUTH_CLASSIC, (String)"add");
            steps[6].get("login-modules").get(0).get("code").set("CertificateRoles");
            steps[6].get("login-modules").get(0).get("flag").set("required");
            steps[6].get("login-modules").get(0).get(new String[]{"module-options", "securityDomain"}).set("certificate-trust-domain");
            steps[6].get("login-modules").get(0).get(new String[]{"module-options", "verifier"}).set("org.jboss.security.auth.certs.AnyCertVerifier");
            steps[6].get("login-modules").get(0).get(new String[]{"module-options", "rolesProperties"}).set("${jboss.home.dir}/standalone/configuration/application-roles.properties");
            steps[7] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_UNDERTOW_HTTPS_LISTENER, (String)"write-attribute");
            steps[7].get("name").set("verify-client");
            steps[7].get("value").set("REQUESTED");
            ModelNode compositeNode = DMRUtils.createCompositeNode((ModelNode[])steps);
            managementClient.getControllerClient().execute(compositeNode);
            this.reload(managementClient);
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            ModelNode[] steps = new ModelNode[5];
            steps[0] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_UNDERTOW_HTTPS_LISTENER, (String)"undefine-attribute");
            steps[0].get("name").set("verify-client");
            steps[1] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CLIENT_CERT, (String)"remove");
            steps[2] = DMRUtils.createOpNode((String)ADDRESS_SUBSYSTEM_SECURITY_SECURITY_DOMAIN_CERTIFICATE_TRUST_DOMAIN, (String)"remove");
            steps[3] = DMRUtils.createOpNode((String)ADDRESS_SYSTEM_PROPERTY_TRUST_STORE, (String)"remove");
            steps[4] = DMRUtils.createOpNode((String)ADDRESS_SYSTEM_PROPERTY_TRUST_STORE_PASSWORD, (String)"remove");
            ModelNode compositeNode = DMRUtils.createCompositeNode((ModelNode[])steps);
            managementClient.getControllerClient().execute(compositeNode);
            UserManager.removeApplicationUser(APPLICATION_USER);
            UserManager.revokeRoleFromApplicationUser(APPLICATION_USER, APPLICATION_ROLE);
        }

        public void reload(ManagementClient managementClient) throws Exception {
            ServerReload.executeReloadAndWaitForCompletion(managementClient.getControllerClient(), 60000);
        }
    }
}

