/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.jms;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.examples.test.common.FileCopyTestSupport;
import org.wildfly.camel.examples.test.common.ServerLogReader;
import org.wildfly.camel.examples.test.jms.AbstractJMSExampleTest;
import org.wildfly.camel.test.common.http.HttpRequest;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={AbstractJMSExampleTest.JmsQueueSetup.class})
public class TransactedJMSExampleTest
extends FileCopyTestSupport {
    private static final String CONTEXT_PATH = "example-camel-jms-tx";
    private static final String EXAMPLE_CAMEL_JMS_WAR = "example-camel-jms-tx.war";

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-jms-tx.war"));
    }

    @Test
    public void testFileToJmsRoute() throws Exception {
        boolean logMessagePresent = ServerLogReader.awaitLogMessage(".*camel-jms-tx-context.*Rollback.*Invalid quantity$", 10000L);
        Assert.assertTrue((String)"Gave up waiting for transaction to rollback", (boolean)logMessagePresent);
        HttpRequest.HttpResponse result = HttpRequest.get((String)("http://localhost:8080/" + this.getContextPath() + "/orders")).getResponse();
        String body = result.getBody();
        Assert.assertFalse((String)"Expected transaction to be rolled back", (boolean)body.contains(this.getExpectedResponseText()));
    }

    @Override
    protected String sourceFilename() {
        return "order-tx.xml";
    }

    @Override
    protected Path destinationPath() {
        return Paths.get(System.getProperty("jboss.home") + "/standalone/data/orders", new String[0]);
    }

    @Override
    protected Path processedPath() {
        return this.destinationPath().resolve(".camel/" + this.sourceFilename());
    }

    private String getContextPath() {
        return CONTEXT_PATH;
    }

    private String getExpectedResponseText() {
        return "Test Product";
    }
}

