/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.mail;

import java.io.File;
import java.net.MalformedURLException;
import javax.annotation.Resource;
import javax.mail.Folder;
import javax.mail.Session;
import javax.mail.Store;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.common.utils.DMRUtils;

public abstract class AbstractMailExampleTest {
    private static final String GREENMAIL_WAR = "greenmail.war";
    @ArquillianResource
    Deployer deployer;
    @Resource(lookup="java:jboss/mail/greenmail")
    private Session mailSession;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{HttpRequest.class, AbstractMailExampleTest.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Deployment(managed=false, testable=false, name="greenmail.war")
    public static WebArchive createGreenmailDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/greenmail-webapp.war"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendEmailTest() throws Exception {
        try {
            this.deployer.deploy(GREENMAIL_WAR);
            this.deployer.deploy(this.getDeploymentName());
            StringBuilder endpointURL = new StringBuilder("from=user1@localhost");
            endpointURL.append("&to=user2@localhost").append("&subject=Greetings").append("&message=Hello");
            HttpRequest.HttpResponse result = HttpRequest.post((String)this.getEndpointAddress("send")).header("Content-Type", "application/x-www-form-urlencoded").content(endpointURL.toString()).getResponse();
            String responseBody = result.getBody();
            Assert.assertTrue((String)("Sent successful: " + responseBody), (boolean)responseBody.contains("Message sent successfully"));
            Store store = this.mailSession.getStore("pop3");
            store.connect();
            Folder folder = store.getFolder("INBOX");
            folder.open(2);
            Assert.assertEquals((long)1L, (long)folder.getMessageCount());
        }
        finally {
            this.deployer.undeploy(this.getDeploymentName());
            this.deployer.undeploy(GREENMAIL_WAR);
        }
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080/" + this.getContextPath() + "/" + contextPath;
    }

    abstract String getContextPath();

    abstract String getDeploymentName();

    static class MailSessionSetupTask
    implements ServerSetupTask {
        MailSessionSetupTask() {
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-smtp", "add(host=localhost, port=10025)").addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-pop3", "add(host=localhost, port=10110)").addStep("subsystem=mail/mail-session=greenmail", "add(jndi-name=java:jboss/mail/greenmail)").addStep("subsystem=mail/mail-session=greenmail/server=smtp", "add(outbound-socket-binding-ref=mail-greenmail-smtp, username=user1, password=password)").addStep("subsystem=mail/mail-session=greenmail/server=pop3", "add(outbound-socket-binding-ref=mail-greenmail-pop3, username=user2, password=password2)").build();
            managementClient.getControllerClient().execute(batchNode);
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            ModelNode batchNode = DMRUtils.batchNode().addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-smtp", "remove").addStep("socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-pop3", "remove").addStep("subsystem=mail/mail-session=greenmail", "remove").addStep("subsystem=mail/mail-session=greenmail/server=smtp", "remove").addStep("subsystem=mail/mail-session=greenmail/server=pop3", "remove").build();
            managementClient.getControllerClient().execute(batchNode);
        }
    }
}

