/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.test.cxf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.examples.test.common.SecurityUtils;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;
import org.wildfly.camel.test.common.utils.FileUtils;
import org.wildfly.camel.test.common.utils.UserManager;
import org.wildfly.camel.test.common.utils.WildFlyCli;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={ClientCertSecurityDomainSetup.class})
public class CxfWsCdiSecureExampleTest {
    private static final Path WILDFLY_HOME = EnvironmentUtils.getWildFlyHome();
    private static final String CLIENT_CERT_KEYSTORE_PASSWORD = "123456";
    private static final String CLIENT_CRT = "client.crt";
    private static final String CLIENT_KEYSTORE = "client.keystore";
    private static final String CLIENT_TRUSTSTORE = "client.truststore";
    private static final String SERVER_CRT = "server.crt";
    private static final String SERVER_KEYSTORE = "server.keystore";
    private static final String SERVER_TRUSTSTORE = "server.truststore";
    private static final String UNTRUSTED_CRT = "untrusted.crt";
    private static final String UNTRUSTED_KEYSTORE = "untrusted.keystore";
    private static final String BASE_URI = "https://localhost:8443";
    private static final String UI_URI = "https://localhost:8443".replace("https:", "http:").replace("8443", "8080") + "/example-camel-cxf-jaxws-cdi-secure/cxf/";
    private static final String CXF_ENDPOINT_URI = "https://localhost:8443/webservices/greeting-secure-cdi";
    private static final String WS_MESSAGE_TEMPLATE = "<Envelope xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\"><Body><greet xmlns=\"http://jaxws.cxf.examples.camel.wildfly.org/\"><message xmlns=\"\">%s</message><name xmlns=\"\">%s</name></greet></Body></Envelope>";
    private static final String CLIENT_ROLE = "testRole";
    private static final String CLIENT_ALIAS = "client";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-cxf-jaxws-cdi-secure.war"));
    }

    @Test
    public void ui() throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost request = new HttpPost(UI_URI);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            request.setEntity((HttpEntity)new StringEntity("message=Hello&name=Kermit", StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                HttpEntity entity = response.getEntity();
                String body = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                Assert.assertTrue((boolean)body.contains("Hello Kermit"));
            }
        }
    }

    @Test
    public void greetAnonymous() throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)CxfWsCdiSecureExampleTest.createUntrustedClientCertSocketFactory(WILDFLY_HOME)).build();){
            HttpPost request = new HttpPost(CXF_ENDPOINT_URI);
            request.setHeader("Content-Type", "text/xml");
            request.setHeader("soapaction", "\"urn:greet\"");
            request.setEntity((HttpEntity)new StringEntity(String.format(WS_MESSAGE_TEMPLATE, "Hi", "Joe"), StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                Assert.assertEquals((long)403L, (long)response.getStatusLine().getStatusCode());
            }
        }
    }

    @Test
    public void greetClientCert() throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)CxfWsCdiSecureExampleTest.createTrustedClientCertSocketFactory(WILDFLY_HOME)).build();){
            HttpPost request = new HttpPost(CXF_ENDPOINT_URI);
            request.setHeader("Content-Type", "text/xml");
            request.setHeader("soapaction", "\"urn:greet\"");
            request.setEntity((HttpEntity)new StringEntity(String.format(WS_MESSAGE_TEMPLATE, "Hi", "Joe"), StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                HttpEntity entity = response.getEntity();
                String body = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                Assert.assertTrue((boolean)body.contains("Hi Joe"));
            }
        }
    }

    private static SSLConnectionSocketFactory createTrustedClientCertSocketFactory(Path wildflyHome) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        Path truststoreFile = CxfWsCdiSecureExampleTest.resolveConfigFile(CLIENT_TRUSTSTORE);
        Path keystoreFile = CxfWsCdiSecureExampleTest.resolveConfigFile(CLIENT_KEYSTORE);
        return SecurityUtils.createSocketFactory(truststoreFile, keystoreFile, CLIENT_CERT_KEYSTORE_PASSWORD);
    }

    private static Path resolveConfigFile(String fileName) {
        return WILDFLY_HOME.resolve("standalone/configuration/" + fileName);
    }

    private static SSLConnectionSocketFactory createUntrustedClientCertSocketFactory(Path wildflyHome) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        Path truststoreFile = CxfWsCdiSecureExampleTest.resolveConfigFile(CLIENT_TRUSTSTORE);
        Path keystoreFile = CxfWsCdiSecureExampleTest.resolveConfigFile(UNTRUSTED_KEYSTORE);
        return SecurityUtils.createSocketFactory(truststoreFile, keystoreFile, CLIENT_CERT_KEYSTORE_PASSWORD);
    }

    static class ClientCertSecurityDomainSetup
    implements ServerSetupTask {
        ClientCertSecurityDomainSetup() {
        }

        private static void copyKeyMaterial(Path wildflyHome) throws IOException, IllegalArgumentException {
            Path targetDirectory = wildflyHome.resolve("standalone/configuration");
            if (targetDirectory == null || !Files.isDirectory(targetDirectory, new LinkOption[0])) {
                throw new IllegalArgumentException("Provide an existing folder as the method parameter.");
            }
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.SERVER_KEYSTORE, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.SERVER_TRUSTSTORE, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.SERVER_CRT, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.CLIENT_KEYSTORE, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.CLIENT_TRUSTSTORE, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.CLIENT_CRT, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.UNTRUSTED_KEYSTORE, targetDirectory);
            ClientCertSecurityDomainSetup.copy(CxfWsCdiSecureExampleTest.UNTRUSTED_CRT, targetDirectory);
        }

        private static void copy(String fileName, Path targetDirectory) throws IOException {
            FileUtils.copy((URL)CxfWsCdiSecureExampleTest.class.getClassLoader().getResource("keys/" + fileName), (Path)targetDirectory.resolve(fileName));
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            ClientCertSecurityDomainSetup.copyKeyMaterial(WILDFLY_HOME);
            try (UserManager um = UserManager.forStandaloneApplicationRealm();){
                um.addRole(CxfWsCdiSecureExampleTest.CLIENT_ALIAS, CxfWsCdiSecureExampleTest.CLIENT_ROLE);
            }
            URL cliUrl = this.getClass().getClassLoader().getResource("configure-tls-security.cli");
            Path cliTmpPath = Files.createTempFile(WildFlyCli.class.getSimpleName(), ".cli", new FileAttribute[0]);
            FileUtils.copy((URL)cliUrl, (Path)cliTmpPath);
            new WildFlyCli().run(cliTmpPath, new String[0]).assertSuccess();
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            try (UserManager um = UserManager.forStandaloneApplicationRealm();){
                um.removeRole(CxfWsCdiSecureExampleTest.CLIENT_ALIAS, CxfWsCdiSecureExampleTest.CLIENT_ROLE);
            }
            URL cliUrl = this.getClass().getClassLoader().getResource("remove-tls-security.cli");
            Path cliTmpPath = Files.createTempFile(WildFlyCli.class.getSimpleName(), ".cli", new FileAttribute[0]);
            FileUtils.copy((URL)cliUrl, (Path)cliTmpPath);
            new WildFlyCli().run(cliTmpPath, new String[0]).assertSuccess();
        }
    }
}

