/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.cdi.Uri;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="jms/queue/OrdersQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class MessageDrivenBean
implements MessageListener {
    @Inject
    @Uri(value="direct:jmsIn")
    private ProducerTemplate template;

    public void onMessage(Message message) {
        try {
            String messagePayload = ((TextMessage)message).getText();
            this.template.sendBody((Object)messagePayload);
        }
        catch (JMSException e) {
            throw new IllegalStateException("Error processing JMS message", e);
        }
    }
}

