/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms.transacted.producer;

import javax.annotation.Resource;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

public class TransactionManagerProducer {
    @Resource(mappedName="java:/TransactionManager")
    private TransactionManager transactionManager;
    @Resource
    private UserTransaction userTransaction;

    @Produces
    @Named(value="transactionManager")
    public PlatformTransactionManager createTransactionManager() {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager();
        jtaTransactionManager.setUserTransaction(this.userTransaction);
        jtaTransactionManager.setTransactionManager(this.transactionManager);
        jtaTransactionManager.afterPropertiesSet();
        return jtaTransactionManager;
    }
}

