/*
 * #%L
 * Wildfly Camel :: Example :: Camel JPA Spring
 * %%
 * Copyright (C) 2013 - 2017 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.camel.examples.jpa.processor;

import java.util.List;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.wildfly.camel.examples.jpa.model.Order;

public class JpaResultProcessor implements Processor {

    @Override
    public void process(Exchange exchange) throws Exception {
        List<Order> orders = exchange.getIn().getBody(List.class);
        if (orders != null && !orders.isEmpty()) {
            exchange.getOut().setBody(orders.get(0));
        }
    }
}
