/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest.data;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.wildfly.camel.examples.rest.model.Customer;

@ApplicationScoped
@Named
public class CustomerRepository {
    @Inject
    private EntityManager em;
    @Inject
    private UserTransaction userTransaction;

    public List<Customer> findAll() {
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Customer.class);
        query.select((Selection)query.from(Customer.class));
        return this.em.createQuery(query).getResultList();
    }

    public Customer findById(Long id) {
        return (Customer)this.em.find(Customer.class, (Object)id);
    }

    public Customer save(Customer customer) {
        Customer customer2;
        try {
            this.userTransaction.begin();
            customer2 = (Customer)this.em.merge((Object)customer);
        }
        catch (Throwable throwable) {
            try {
                this.userTransaction.commit();
                throw throwable;
            }
            catch (Exception e) {
                try {
                    this.userTransaction.rollback();
                }
                catch (SystemException se) {
                    throw new RuntimeException(se);
                }
                throw new RuntimeException(e);
            }
        }
        this.userTransaction.commit();
        return customer2;
    }

    public void delete(Customer customer) {
        try {
            try {
                this.userTransaction.begin();
                if (!this.em.contains((Object)customer)) {
                    customer = (Customer)this.em.merge((Object)customer);
                }
                this.em.remove((Object)customer);
            }
            finally {
                this.userTransaction.commit();
            }
        }
        catch (Exception e) {
            try {
                this.userTransaction.rollback();
            }
            catch (SystemException se) {
                throw new RuntimeException(se);
            }
            throw new RuntimeException(e);
        }
    }
}

