/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.catalog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CatalogCreator {
    static final Path resdir = CatalogCreator.basedir().resolve(Paths.get("src/main/resources", new String[0]));
    static final Path srcdir = CatalogCreator.basedir().resolve(Paths.get("target/camel-catalog", new String[0]));
    static final Path outdir = CatalogCreator.basedir().resolve(Paths.get("target/classes", new String[0]));
    private Map<Kind, RoadMap> ROAD_MAPS = new LinkedHashMap<Kind, RoadMap>();

    public static Path basedir() {
        String basedir = System.getProperty("basedir");
        return Paths.get(basedir != null ? basedir : ".", new String[0]);
    }

    public CatalogCreator() {
        this.ROAD_MAPS.put(Kind.component, new RoadMap(Kind.component));
        this.ROAD_MAPS.put(Kind.dataformat, new RoadMap(Kind.dataformat));
        this.ROAD_MAPS.put(Kind.language, new RoadMap(Kind.language));
        this.ROAD_MAPS.put(Kind.other, new RoadMap(Kind.other));
    }

    public static void main(String[] args) throws Exception {
        new CatalogCreator().collect().generate();
    }

    public CatalogCreator collect() throws Exception {
        this.collectAvailable();
        this.collectSupported();
        return this;
    }

    public CatalogCreator generate() throws Exception {
        this.generateProperties();
        this.generateRoadmaps();
        return this;
    }

    public RoadMap getRoadmap(Kind kind) {
        return this.ROAD_MAPS.get((Object)kind);
    }

    public List<RoadMap> getRoadmaps() {
        return new ArrayList<RoadMap>(this.ROAD_MAPS.values());
    }

    private void collectAvailable() throws IOException {
        Files.walkFileTree(srcdir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (path.toString().endsWith(".json")) {
                    boolean deprecated;
                    Path relpath = srcdir.relativize(path);
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode treeNode = mapper.readTree(path.toFile());
                    JsonNode valnode = treeNode.findValue("kind");
                    String kind = valnode != null ? valnode.textValue() : null;
                    valnode = treeNode.findValue("artifactId");
                    String artifactId = valnode != null ? valnode.textValue() : null;
                    valnode = treeNode.findValue("deprecated");
                    boolean bl = deprecated = valnode != null ? valnode.booleanValue() : false;
                    if (this.validKind(kind, treeNode)) {
                        Item item = new Item(relpath, Kind.valueOf(kind), artifactId, deprecated);
                        ((RoadMap)CatalogCreator.this.ROAD_MAPS.get((Object)item.kind)).add(item);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            boolean validKind(String kind, JsonNode node) {
                JsonNode valnode = node.findValue("name");
                String name = valnode != null ? valnode.textValue() : null;
                try {
                    Kind.valueOf(kind);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    if (!kind.equals("model")) {
                        System.err.println("Invalid kind for " + name + ": " + kind);
                    }
                    return false;
                }
            }
        });
        for (RoadMap roadmap : this.ROAD_MAPS.values()) {
            State state = null;
            File file = roadmap.outpath.toFile();
            try {
                BufferedReader br = new BufferedReader(new FileReader(file));
                Throwable throwable = null;
                try {
                    String line = br.readLine().trim();
                    while (line != null) {
                        if (line.length() > 0 && !line.startsWith("#")) {
                            int idx;
                            if (line.startsWith("[")) {
                                state = State.valueOf(line.substring(1, line.length() - 1));
                            }
                            String name = (idx = line.indexOf("#")) > 0 ? line.substring(0, idx).trim() : line;
                            String comment = idx > 0 ? line.substring(idx).trim() : null;
                            Item item = roadmap.item(name);
                            if (item != null) {
                                if (state == State.planned || state == State.rejected) {
                                    item.state = state;
                                }
                                item.comment = comment;
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void collectSupported() throws IOException {
        Path rootPath = CatalogCreator.basedir().resolve(Paths.get("target", "dependency"));
        for (RoadMap roadmap : this.ROAD_MAPS.values()) {
            for (Item item : roadmap.items.values()) {
                if (!rootPath.resolve(item.artifactId + ".jar").toFile().isFile()) continue;
                Path subpath = item.path.subpath(2, item.path.getNameCount());
                Path targetPath = Paths.get("org", "wildfly").resolve(subpath);
                Path target = outdir.resolve(targetPath);
                Path source = srcdir.resolve(item.path);
                target.getParent().toFile().mkdirs();
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                item.state = State.supported;
            }
        }
    }

    private void generateProperties() throws IOException {
        for (RoadMap roadmap : this.ROAD_MAPS.values()) {
            File outfile = outdir.resolve("org/wildfly/camel/catalog/" + (Object)((Object)roadmap.kind) + "s.properties").toFile();
            PrintWriter pw = new PrintWriter(outfile);
            Throwable throwable = null;
            try {
                for (String name : roadmap.sortedNames(State.supported)) {
                    pw.println(name);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw == null) continue;
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pw.close();
            }
        }
    }

    private void generateRoadmaps() throws IOException {
        for (RoadMap roadmap : this.ROAD_MAPS.values()) {
            PrintWriter pw = new PrintWriter(roadmap.outpath.toFile());
            Throwable throwable = null;
            try {
                int maxlength = 0;
                for (String entry : roadmap.sortedNames(null)) {
                    Item item = roadmap.item(entry);
                    maxlength = Math.max(maxlength, item.name.length());
                }
                maxlength = maxlength / 16 * 16 + 20;
                for (State state : State.values()) {
                    pw.println("[" + (Object)((Object)state) + "]");
                    for (String entry : roadmap.sortedNames(state)) {
                        String comment;
                        Item item = roadmap.item(entry);
                        StringBuffer line = new StringBuffer(item.name);
                        String string = comment = item.deprecated ? "#deprecated" : item.comment;
                        if (comment != null) {
                            for (int i = 0; i < maxlength - item.name.length(); ++i) {
                                line.append(" ");
                            }
                            line.append(comment);
                        }
                        pw.println(line);
                    }
                    pw.println();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw == null) continue;
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pw.close();
            }
        }
    }

    public static class RoadMap {
        final Kind kind;
        final Path outpath;
        final Map<String, Item> items = new HashMap<String, Item>();

        RoadMap(Kind kind) {
            this.outpath = resdir.resolve((Object)((Object)kind) + ".roadmap");
            this.kind = kind;
        }

        void add(Item item) {
            this.items.put(item.name, item);
        }

        public Kind getKind() {
            return this.kind;
        }

        public Path getOutpath() {
            return this.outpath;
        }

        public Item item(String name) {
            return this.items.get(name);
        }

        public List<String> sortedNames(State state) {
            ArrayList<String> result = new ArrayList<String>();
            for (Item item : this.items.values()) {
                if (state != null && item.state != state) continue;
                result.add(item.name);
            }
            Collections.sort(result);
            return result;
        }
    }

    public static class Item {
        final Path path;
        final Kind kind;
        final String name;
        final String artifactId;
        final boolean deprecated;
        String comment;
        State state = State.undecided;

        Item(Path path, Kind kind, String artifactId, boolean deprecated) {
            this.path = path;
            this.kind = kind;
            this.artifactId = artifactId;
            this.deprecated = deprecated;
            String nspec = path.getFileName().toString();
            this.name = nspec = nspec.substring(0, nspec.indexOf("."));
        }
    }

    public static enum State {
        supported,
        planned,
        undecided,
        rejected;

    }

    public static enum Kind {
        component,
        dataformat,
        language,
        other;

    }
}

