/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.config;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.wildfly.extras.config.ConfigContext;
import org.wildfly.extras.config.ConfigPlugin;
import org.wildfly.extras.config.ConfigSupport;
import org.wildfly.extras.config.LayerConfig;

public final class WildFlyCamelConfigPlugin
implements ConfigPlugin {
    public static final Namespace NS_DOMAIN_100 = Namespace.getNamespace((String)"urn:jboss:domain:10.0");
    public static final Namespace[] NS_DOMAINS = new Namespace[]{NS_DOMAIN_100};
    public static final Namespace NS_CAMEL = Namespace.getNamespace((String)"urn:jboss:domain:camel:1.0");
    public static final Namespace NS_SECURITY = Namespace.getNamespace((String)"urn:jboss:domain:security:2.0");

    @Override
    public String getConfigName() {
        return "camel";
    }

    @Override
    public List<LayerConfig> getLayerConfigs() {
        return Arrays.asList(LayerConfig.FUSE_LAYER);
    }

    @Override
    public boolean applyStandaloneConfigChange(ConfigContext context, boolean enable) {
        WildFlyCamelConfigPlugin.updateExtension(context, enable);
        WildFlyCamelConfigPlugin.updateSystemProperties(context, enable);
        WildFlyCamelConfigPlugin.updateSubsystem(context, enable);
        WildFlyCamelConfigPlugin.updateSecurityDomain(context, enable);
        return true;
    }

    @Override
    public boolean applyDomainConfigChange(ConfigContext context, boolean enable) {
        this.applyStandaloneConfigChange(context, enable);
        WildFlyCamelConfigPlugin.updateServergroup(enable, context);
        return true;
    }

    private static void updateExtension(ConfigContext context, boolean enable) {
        Element extensions = ConfigSupport.findChildElement(context.getDocument().getRootElement(), "extensions", NS_DOMAINS);
        ConfigSupport.assertExists(extensions, "Did not find the <extensions> element");
        Namespace namespace = extensions.getNamespace();
        Element element = ConfigSupport.findElementWithAttributeValue(extensions, "extension", "module", "org.wildfly.extension.camel", NS_DOMAINS);
        if (enable && element == null) {
            extensions.addContent((Content)new Text("    "));
            extensions.addContent((Content)new Element("extension", namespace).setAttribute("module", "org.wildfly.extension.camel"));
            extensions.addContent((Content)new Text("\n    "));
        }
        if (!enable && element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }

    private static void updateSystemProperties(ConfigContext context, boolean enable) {
        Element rootElement = context.getDocument().getRootElement();
        Element extensions = ConfigSupport.findChildElement(rootElement, "extensions", NS_DOMAINS);
        ConfigSupport.assertExists(extensions, "Did not find the <extensions> element");
        Namespace namespace = extensions.getNamespace();
        Element element = ConfigSupport.findChildElement(rootElement, "system-properties", NS_DOMAINS);
        if (element == null) {
            element = new Element("system-properties", namespace);
            element.addContent((Content)new Text("\n    "));
            int pos = rootElement.indexOf((Content)extensions);
            rootElement.addContent(pos + 1, (Content)new Text("    "));
            rootElement.addContent(pos + 1, (Content)element);
            rootElement.addContent(pos + 1, (Content)new Text("\n    "));
        }
        Map<String, Element> propertiesByName = ConfigSupport.mapByAttributeName(element.getChildren(), "name");
        if (enable) {
            WildFlyCamelConfigPlugin.addProperty(element, propertiesByName, "hawtio.authenticationEnabled", "true");
            WildFlyCamelConfigPlugin.addProperty(element, propertiesByName, "hawtio.realm", "hawtio-domain");
            WildFlyCamelConfigPlugin.addProperty(element, propertiesByName, "org.apache.xml.dtm.DTMManager", "org.apache.xml.dtm.ref.DTMManagerDefault");
        } else {
            WildFlyCamelConfigPlugin.removeProperty(propertiesByName, "hawtio.authenticationEnabled");
            WildFlyCamelConfigPlugin.removeProperty(propertiesByName, "hawtio.realm");
        }
    }

    private static void updateSubsystem(ConfigContext context, boolean enable) {
        List<Element> profiles = ConfigSupport.findProfileElements(context.getDocument(), NS_DOMAINS);
        for (Element profile : profiles) {
            Element element = profile.getChild("subsystem", NS_CAMEL);
            if (enable && element == null) {
                URL resource = WildFlyCamelConfigPlugin.class.getResource("/camel-subsystem.xml");
                profile.addContent((Content)new Text("    "));
                profile.addContent((Content)ConfigSupport.loadElementFrom(resource));
                profile.addContent((Content)new Text("\n    "));
            }
            if (enable || element == null) continue;
            element.getParentElement().removeContent((Content)element);
        }
    }

    private static void updateSecurityDomain(ConfigContext context, boolean enable) {
        List<Element> profiles = ConfigSupport.findProfileElements(context.getDocument(), NS_DOMAINS);
        for (Element profile : profiles) {
            Element security = profile.getChild("subsystem", NS_SECURITY);
            if (security == null) continue;
            Element domains = security.getChild("security-domains", NS_SECURITY);
            ConfigSupport.assertExists(domains, "Did not find the <security-domains> element");
            Element domain = ConfigSupport.findElementWithAttributeValue(domains, "security-domain", "name", "hawtio-domain", NS_SECURITY);
            if (enable && domain == null) {
                URL resource = WildFlyCamelConfigPlugin.class.getResource("/hawtio-security-domain.xml");
                domains.addContent((Content)new Text("    "));
                domains.addContent((Content)ConfigSupport.loadElementFrom(resource));
                domains.addContent((Content)new Text("\n            "));
            }
            if (enable || domain == null) continue;
            domain.getParentElement().removeContent((Content)domain);
        }
    }

    private static void updateServergroup(boolean enable, ConfigContext context) {
        Element serverGroups = ConfigSupport.findChildElement(context.getDocument().getRootElement(), "server-groups", NS_DOMAINS);
        Element camel = ConfigSupport.findElementWithAttributeValue(serverGroups, "server-group", "name", "camel-server-group", NS_DOMAINS);
        if (enable && camel == null) {
            URL resource = WildFlyCamelConfigPlugin.class.getResource("/camel-servergroup.xml");
            serverGroups.addContent((Content)new Text("    "));
            serverGroups.addContent((Content)ConfigSupport.loadElementFrom(resource));
            serverGroups.addContent((Content)new Text("\n    "));
        }
        if (!enable && camel != null) {
            camel.getParentElement().removeContent((Content)camel);
        }
    }

    private static void addProperty(Element systemProperties, Map<String, Element> propertiesByName, String name, String value) {
        Namespace namespace = systemProperties.getNamespace();
        if (!propertiesByName.containsKey(name)) {
            systemProperties.addContent((Content)new Text("   "));
            systemProperties.addContent((Content)new Element("property", namespace).setAttribute("name", name).setAttribute("value", value));
            systemProperties.addContent((Content)new Text("\n    "));
        }
    }

    private static void removeProperty(Map<String, Element> propertiesByName, String name) {
        Element element = propertiesByName.get(name);
        if (element != null) {
            element.getParentElement().removeContent((Content)element);
        }
    }
}

