/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Namespace;
import org.wildfly.extras.config.internal.IllegalArgumentAssertion;

public class NamespaceRegistry {
    private Map<String, List<Namespace>> namespaces = new LinkedHashMap<String, List<Namespace>>();

    public void registerNamespace(String namespace, String version) {
        if (!this.namespaces.containsKey(namespace)) {
            this.namespaces.put(namespace, new ArrayList());
        }
        this.namespaces.get(namespace).add(Namespace.getNamespace((String)(namespace + ":" + version)));
    }

    public Namespace[] getNamespaces(String namespace) {
        IllegalArgumentAssertion.assertTrue(this.namespaces.containsKey(namespace), "Unsupported namespace: " + namespace);
        List<Namespace> namespaces = this.namespaces.get(namespace);
        return namespaces.toArray(new Namespace[namespaces.size()]);
    }
}

