/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.EntityResolver;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.dtd.DocType;
import de.pdark.decentxml.dtd.DocTypeEntity;

public class DocTypeEntityResolver
extends EntityResolver {
    private final DocType docType;

    public DocTypeEntityResolver(DocType docType) {
        this.docType = docType;
    }

    public DocTypeEntityResolver(DocType docType, EntityResolver parent) {
        super(parent);
        this.docType = docType;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public boolean isDefined(String name) {
        DocTypeEntity e = this.docType.getEntity(name = this.stripName(name));
        if (e == null) {
            return super.isDefined(name);
        }
        return true;
    }

    public String resolve(String name) {
        DocTypeEntity e = this.docType.getEntity(name = this.stripName(name));
        if (e == null) {
            return super.resolve(name);
        }
        String s = e.getResolvedText();
        if (s == null) {
            s = this.resolveLiteralValueOfEntity(name, e.getText());
            e.setResolvedText(s);
        }
        return s;
    }

    public String resolveLiteralValueOfEntity(String name, String text) {
        int pos = 0;
        int N = text.length();
        StringBuilder buffer = new StringBuilder(1024);
        while (pos < N) {
            int endPos;
            int parEntityPos = text.indexOf(37, pos);
            int charEntityPos = text.indexOf("&#", pos);
            if (parEntityPos == -1 && charEntityPos == -1) break;
            if (parEntityPos == -1) {
                parEntityPos = N;
            }
            if (charEntityPos == -1) {
                charEntityPos = N;
            }
            if (parEntityPos < charEntityPos) {
                String parEntityName;
                DocTypeEntity parEntity;
                String s;
                if (pos < parEntityPos) {
                    buffer.append(text, pos, parEntityPos);
                }
                if ((endPos = text.indexOf(59, parEntityPos)) == -1) {
                    throw new XMLParseException("Missing ';' after '%' of parameter entity name: " + text.substring(parEntityPos));
                }
                if ((s = (parEntity = this.docType.getParameterEntity(parEntityName = text.substring(parEntityPos + 1, ++endPos - 1))).getResolvedText()) == null) {
                    s = this.resolveLiteralValueOfEntity(parEntityName, s);
                    parEntity.setResolvedText(s);
                }
                buffer.append(s);
                pos = endPos;
                continue;
            }
            if (pos < charEntityPos) {
                buffer.append(text, pos, charEntityPos);
            }
            if ((endPos = text.indexOf(59, charEntityPos)) == -1) {
                throw new XMLParseException("Missing ';' after '&#' of character entity: " + text.substring(charEntityPos));
            }
            String s = text.substring(charEntityPos, ++endPos);
            buffer.append(this.expand(s));
            pos = endPos;
        }
        if (pos < N) {
            buffer.append(text, pos, N);
        }
        return buffer.toString();
    }
}

