/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.config;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLStringSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.wildfly.extension.camel.config.ConfigEditor;
import org.wildfly.extension.camel.config.ConfigMain;

public class ConfigSupport {
    static final List<String> standalonePaths = new ArrayList<String>();
    static final List<String> domainPaths = new ArrayList<String>();

    static String getJBossHome() throws UnsupportedEncodingException {
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            String path = ConfigMain.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            String containingFolder = decodedPath.substring(0, decodedPath.lastIndexOf(File.separator));
            if (containingFolder.endsWith("bin")) {
                jbossHome = containingFolder.substring(0, containingFolder.lastIndexOf(File.separator));
            } else {
                throw new CommandException("The execution is not correct. This jar should be placed inside of ${JBOSS_HOME}/bin");
            }
        }
        String standalonePath = jbossHome + "/standalone/configuration";
        String domainPath = jbossHome + "/domain/configuration";
        File stanaloneFile = new File(standalonePath);
        File domainFile = new File(domainPath);
        if (!stanaloneFile.exists() || !domainFile.exists()) {
            throw new CommandException("\t The execution is not correct. This jar should be placed inside of ${JBOSS_HOME}/bin");
        }
        return jbossHome;
    }

    public static void applyConfigChange(String jbossHome, boolean enable, ConfigEditor editor) throws Exception {
        String newXML;
        Document doc;
        String xml;
        String path;
        XMLParser parser = new XMLParser();
        for (String p : standalonePaths) {
            path = jbossHome + p;
            System.out.println("\tEnabling configuration on " + path);
            xml = ConfigSupport.readFile(path, "UTF-8");
            doc = parser.parse(new XMLStringSource(xml));
            editor.applyStandaloneConfigChange(enable, doc);
            newXML = doc.toXML();
            if (newXML.equals(xml)) continue;
            ConfigSupport.backup(path, xml);
            ConfigSupport.writeFile(path, newXML, "UTF-8");
        }
        for (String p : domainPaths) {
            path = jbossHome + p;
            System.out.println("\tEnabling configuration on " + path);
            xml = ConfigSupport.readFile(path, "UTF-8");
            doc = parser.parse(new XMLStringSource(xml));
            editor.applyDomainConfigChange(enable, doc);
            newXML = doc.toXML();
            if (newXML.equals(xml)) continue;
            ConfigSupport.backup(path, xml);
            ConfigSupport.writeFile(path, newXML, "UTF-8");
        }
    }

    static Element createElementFromText(String xml) {
        XMLParser parser = new XMLParser();
        Document doc = parser.parse(new XMLStringSource(xml));
        return doc.getRootElement();
    }

    static Element loadElementFrom(URL resource) {
        try {
            byte[] data = ConfigSupport.loadBytesFromURL(resource);
            String xml = new String(data, "UTF-8");
            return ConfigSupport.createElementFromText(xml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] loadBytesFromURL(URL resource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[10234];
        try (InputStream in = resource.openStream();){
            int count;
            while ((count = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, count);
            }
        }
        return out.toByteArray();
    }

    static Element findElementWithAttributeValue(Collection<Element> elements, String attrName, String attrValue) {
        if (elements == null) {
            return null;
        }
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null || !attrValue.equals(attribute.getValue())) continue;
            return element;
        }
        return null;
    }

    static Element findElementWithStartingAttributeValue(Collection<Element> elements, String attrName, String attrValue) {
        if (elements == null) {
            return null;
        }
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null || !attribute.getValue().startsWith(attrValue)) continue;
            return element;
        }
        return null;
    }

    static void assertExists(Element extensions, String message) {
        if (extensions == null) {
            throw new BadDocument(message);
        }
    }

    static void backup(String path, String xml) throws IOException {
        String name = path + ".bak";
        int counter = 2;
        while (Files.exists(Paths.get(name, new String[0]), new LinkOption[0])) {
            name = path + ".bak" + counter;
            ++counter;
        }
        ConfigSupport.writeFile(name, xml, "UTF-8");
    }

    static String readFile(String path, String encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    static Path writeFile(String path, String value, String encoding) throws IOException {
        byte[] bytes = value.getBytes(encoding);
        return Files.write(Paths.get(path, new String[0]), bytes, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    }

    static LinkedHashMap<String, Element> mapByAttributeName(List<Element> elements, String attrName) {
        LinkedHashMap<String, Element> rc = new LinkedHashMap<String, Element>();
        for (Element element : elements) {
            Attribute attribute = element.getAttribute(attrName);
            if (attribute == null) continue;
            rc.put(attribute.getValue(), element);
        }
        return rc;
    }

    static List<Element> findProfileElements(Document doc) {
        Element profiles;
        ArrayList<Element> result = new ArrayList<Element>();
        Element profile = doc.getRootElement().getChild("profile");
        if (profile != null) {
            result.add(profile);
        }
        if ((profiles = doc.getRootElement().getChild("profiles")) != null) {
            result.addAll(profiles.getChildren("profile"));
        }
        return result;
    }

    static {
        standalonePaths.add("/standalone/configuration/standalone.xml");
        standalonePaths.add("/standalone/configuration/standalone-full.xml");
        standalonePaths.add("/standalone/configuration/standalone-full-ha.xml");
        standalonePaths.add("/standalone/configuration/standalone-ha.xml");
        domainPaths.add("/domain/configuration/domain.xml");
    }

    static class CommandException
    extends RuntimeException {
        CommandException(String message) {
            super(message);
        }
    }

    static class BadDocument
    extends RuntimeException {
        BadDocument(String message) {
            super(message);
        }
    }
}

