/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.config.internal;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.wildfly.extension.camel.config.ConfigException;
import org.wildfly.extension.camel.config.ConfigLogger;
import org.wildfly.extension.camel.config.ConfigSupport;
import org.wildfly.extension.camel.config.internal.Options;

public class Main {
    static String PROCESS_NAME = "wildfly-camel-config.jar";

    public static void main(String[] args) {
        try {
            Main.mainInternal(args);
        }
        catch (Throwable th) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void mainInternal(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            Main.helpScreen(parser);
            return;
        }
        try {
            ArrayList<String> configs = new ArrayList<String>();
            if (options.configs != null) {
                configs.addAll(Arrays.asList(options.configs.split(",")));
            }
            ConfigSupport.applyConfigChange(ConfigSupport.getJBossHome(), configs, options.enable);
        }
        catch (ConfigException ex) {
            ConfigLogger.error(ex);
            throw ex;
        }
        catch (Throwable th) {
            ConfigLogger.error(th);
            throw th;
        }
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        ConfigLogger.error("fuseconfig [options...]");
        cmdParser.printUsage((OutputStream)System.err);
    }
}

