/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.undertow.wildfly;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.transport.undertow.AbstractHTTPServerEngine;
import org.apache.cxf.transport.undertow.UndertowHTTPHandler;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extension.camel.service.CamelEndpointDeploymentSchedulerService;

class WildflyHTTPServerEngine
extends AbstractHTTPServerEngine {
    private static final Logger LOG = LoggerFactory.getLogger(WildflyHTTPServerEngine.class);
    private final Map<URI, ServiceName> uriServiceNameMap = new HashMap<URI, ServiceName>();

    WildflyHTTPServerEngine(String protocol, String host, int port) {
        super(protocol, host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServant(URL nurl, UndertowHTTPHandler handler) {
        try {
            URI uri = nurl.toURI();
            LOG.debug("Adding CXF servant for URI {}", (Object)uri);
            ServiceName serviceName = CamelEndpointDeploymentSchedulerService.deploymentSchedulerServiceName((ClassLoader)handler.getHTTPDestination().getClassLoader());
            ServiceController serviceControler = CurrentServiceContainer.getServiceContainer().getRequiredService(serviceName);
            CamelEndpointDeploymentSchedulerService deploymentSchedulerService = (CamelEndpointDeploymentSchedulerService)serviceControler.getValue();
            deploymentSchedulerService.schedule(uri, (CamelEndpointDeploymentSchedulerService.EndpointHttpHandler)handler.getHTTPDestination());
            Map<URI, ServiceName> map = this.uriServiceNameMap;
            synchronized (map) {
                this.uriServiceNameMap.put(uri, serviceName);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServant(URL nurl) {
        try {
            URI uri = nurl.toURI();
            LOG.debug("Removing CXF servant for URI {}", (Object)uri);
            ServiceName serviceName = null;
            Map<URI, ServiceName> map = this.uriServiceNameMap;
            synchronized (map) {
                serviceName = this.uriServiceNameMap.remove(uri);
            }
            if (serviceName != null) {
                ServiceController serviceControler = CurrentServiceContainer.getServiceContainer().getRequiredService(serviceName);
                CamelEndpointDeploymentSchedulerService deploymentSchedulerService = (CamelEndpointDeploymentSchedulerService)serviceControler.getValue();
                deploymentSchedulerService.unschedule(uri);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

