/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.undertow;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.transport.undertow.AbstractHTTPServerEngine;
import org.apache.cxf.transport.undertow.HttpServerEngine;
import org.apache.cxf.transport.undertow.HttpServerEngineFactory;

public abstract class AbstractHTTPServerEngineFactory
implements HttpServerEngineFactory {
    private final Map<Integer, AbstractHTTPServerEngine> registry = new HashMap<Integer, AbstractHTTPServerEngine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerEngine retrieveHTTPServerEngine(int port) {
        Map<Integer, AbstractHTTPServerEngine> map = this.registry;
        synchronized (map) {
            return this.registry.get(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerEngine getHTTPServerEngine(String host, int port, String protocol) {
        if (!"http".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        Map<Integer, AbstractHTTPServerEngine> map = this.registry;
        synchronized (map) {
            if (this.registry.get(port) != null) {
                throw new IllegalStateException("Server engine already crated for port: " + port);
            }
            AbstractHTTPServerEngine engine = this.createHTTPServerEngine(host, port, protocol);
            this.registry.put(port, engine);
            return engine;
        }
    }
}

