/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.undertow.wildfly.subsystem.extension;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.undertow.UndertowDestinationFactory;
import org.apache.cxf.transport.undertow.wildfly.subsystem.extension.SecurityActions;
import org.wildfly.extension.camel.ContextCreateHandler;

public final class CxfDefaultBusHandler
implements ContextCreateHandler {
    private final LifecycleStrategy endpointStrategy = new CxfDefaultBusEndpointStrategy();

    public void setup(CamelContext camelctx) {
        camelctx.addLifecycleStrategy(this.endpointStrategy);
    }

    static class CxfDefaultBusEndpointStrategy
    extends LifecycleStrategySupport {
        private final Bus bus;

        public CxfDefaultBusEndpointStrategy() {
            Bus bus;
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(CxfComponent.class.getClassLoader());
                bus = BusFactory.getDefaultBus((boolean)true);
            }
            finally {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
            HttpDestinationFactory httpDestinationFactory = (HttpDestinationFactory)bus.getExtension(HttpDestinationFactory.class);
            if (!(httpDestinationFactory instanceof UndertowDestinationFactory)) {
                throw new IllegalStateException(String.format("Expected %s returning %s, found %s", Bus.class.getName(), UndertowDestinationFactory.class.getName(), httpDestinationFactory.getClass().getName()));
            }
            this.bus = bus;
        }

        public void onRoutesAdd(Collection<Route> routes) {
            for (Route route : routes) {
                CxfRsEndpoint rsEnspoint;
                Bus endpointBus;
                Endpoint endpoint = route.getEndpoint();
                if (!(endpoint instanceof CxfRsEndpoint) || (endpointBus = (rsEnspoint = (CxfRsEndpoint)endpoint).getBus()) != null && (endpointBus == this.bus || endpointBus.getExtension(HttpDestinationFactory.class) instanceof UndertowDestinationFactory)) continue;
                throw new IllegalStateException("A " + CxfRsEndpoint.class.getName() + " used in route " + route + " either does not have " + Bus.class.getName() + " set or the " + Bus.class.getSimpleName() + " set was not created using correct context class loader. This is known to happen for " + CxfRsEndpoint.class.getName() + " instances created by direct constructor invocation. Consider using camelContext.getEndpoint(\"cxfrs:http[s]://my-host/my-endpoint\", CxfRsEndpoint.class) instead or add your manually created endpoint to the context management manually using CamelContext.addEndpoint(String uri, Endpoint endpoint)");
            }
        }

        public void onEndpointAdd(Endpoint endpoint) {
            CxfRsEndpoint rsEndPoint;
            if (endpoint instanceof CxfRsEndpoint && (rsEndPoint = (CxfRsEndpoint)endpoint).getBus() == null) {
                rsEndPoint.setBus(this.bus);
            }
        }
    }
}

