/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi.subA;

import javax.inject.Inject;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.Uri;
import org.apache.camel.component.mock.MockEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.cdi.subA.Constants;

@ContextName(value="contextC")
public class RoutesContextC
extends RouteBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesContextC.class);
    @Inject
    @Uri(value="seda:C.a")
    Endpoint a;
    @EndpointInject(uri="mock:C.b")
    public MockEndpoint b;
    @Inject
    @Uri(value="seda:C.a")
    ProducerTemplate producer;

    public void configure() throws Exception {
        this.from(this.a).to((Endpoint)this.b);
    }

    public void sendMessages() {
        for (Object expectedBody : Constants.EXPECTED_BODIES_C) {
            LOG.info("Sending " + expectedBody + " to " + this.producer.getDefaultEndpoint());
            this.producer.sendBody(expectedBody);
        }
    }
}

