/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.classloading;

import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CustomComponentsTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"no-mqtt-tests");
        archive.addAsResource("classloading/jboss-all-custom-components.xml", "META-INF/jboss-all.xml");
        return archive;
    }

    @Test
    public void testMQTTComponentDoesNotLoad() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        try {
            camelctx.getEndpoint("mqtt://dummy");
            Assert.fail((String)"Expected a ResolveEndpointFailedException");
        }
        catch (ResolveEndpointFailedException resolveEndpointFailedException) {
            // empty catch block
        }
    }

    @Test
    public void testFtpComponentLoads() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("ftp://localhost/foo");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.file.remote.FtpEndpoint");
        camelctx.stop();
    }

    @Test
    public void testRssComponentLoads() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Endpoint endpoint = camelctx.getEndpoint("rss://https://developer.jboss.org/blogs/feeds/posts?splitEntries=true");
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.rss.RssEndpoint");
        camelctx.stop();
    }
}

