/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.hawtio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.DatatypeConverter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HawtIOIntegrationTest {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "mgmnt-pa$$wrd1";

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"hawtio-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessHawtIO() throws Exception {
        URL url = new URL("http://localhost:8080/hawtio/jolokia/read/java.lang:type=Memory/HeapMemoryUsage/used");
        URLConnection conn = url.openConnection();
        try {
            String userpass = "admin:mgmnt-pa$$wrd1";
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
            conn.setRequestProperty("Authorization", basicAuth);
            int code = ((HttpURLConnection)conn).getResponseCode();
            Assert.assertEquals((long)200L, (long)code);
            String content = new String(this.readFully((InputStream)conn.getContent()), "UTF-8");
            Assert.assertTrue((String)("Unexpected content: " + content), (boolean)content.contains("\"mbean\":\"java.lang:type=Memory\""));
        }
        finally {
            try {
                conn.getInputStream().close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnauthedAccessHawtIO() throws Exception {
        URL url = new URL("http://localhost:8080/hawtio/jolokia/read/java.lang:type=Memory/HeapMemoryUsage/used");
        URLConnection conn = url.openConnection();
        try {
            int code = ((HttpURLConnection)conn).getResponseCode();
            Assert.assertEquals((long)403L, (long)code);
        }
        finally {
            try {
                conn.getInputStream().close();
            }
            catch (Throwable throwable) {}
        }
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }
}

