/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jaxb;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class JAXBInitalizationTest {
    @Deployment
    public static WebArchive deployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxb-initialization-tests.war");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDumpingCamelModel() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("route-1").to("log:test");
            }
        });
        camelctx.start();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            String xml = ModelHelper.dumpModelAsXml((CamelContext)camelctx, (NamedNode)camelctx.getRouteDefinition("route-1"));
            Assert.assertTrue((boolean)xml.contains("log:test"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
            camelctx.stop();
        }
    }
}

