/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.soap;

import java.io.InputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.soap.SoapJaxbDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.Element;
import org.wildfly.camel.test.common.XMLUtils;
import org.wildfly.camel.test.jaxb.model.Customer;

@RunWith(value=Arquillian.class)
public class SOAPIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"soap-dataformat-tests");
        archive.addPackage(Customer.class.getPackage());
        archive.addClasses(new Class[]{XMLUtils.class});
        archive.addAsResource((Asset)new StringAsset("Customer"), "org/wildfly/camel/test/jaxb/model/jaxb.index");
        archive.addAsResource("soap/envelope.xml", "envelope.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.jdom");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoapMarshal() throws Exception {
        final SoapJaxbDataFormat format = new SoapJaxbDataFormat();
        format.setContextPath("org.wildfly.camel.test.jaxb.model");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal((DataFormat)format);
            }
        });
        InputStream input = this.getClass().getResourceAsStream("/envelope.xml");
        String expected = XMLUtils.compactXML((InputStream)input);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = new Customer("John", "Doe");
            String customerXML = (String)producer.requestBody("direct:start", (Object)customer, String.class);
            Assert.assertEquals((Object)expected, (Object)XMLUtils.compactXML((String)customerXML));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbUnmarshal() throws Exception {
        final SoapJaxbDataFormat format = new SoapJaxbDataFormat();
        format.setContextPath("org.wildfly.camel.test.jaxb.model");
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormat)format);
            }
        });
        InputStream input = this.getClass().getResourceAsStream("/envelope.xml");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Element response = (Element)producer.requestBody("direct:start", (Object)input, Element.class);
            Assert.assertEquals((Object)"Customer", (Object)response.getLocalName());
        }
        finally {
            camelctx.stop();
        }
    }
}

