/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class ConstantBeanHolder
implements BeanHolder {
    private final Object bean;
    private final BeanInfo beanInfo;
    private final Processor processor;

    public ConstantBeanHolder(Object bean, BeanInfo beanInfo) {
        ObjectHelper.notNull(bean, "bean");
        ObjectHelper.notNull(beanInfo, "beanInfo");
        this.bean = bean;
        this.beanInfo = beanInfo;
        this.processor = CamelContextHelper.convertTo(beanInfo.getCamelContext(), Processor.class, bean);
    }

    public ConstantBeanHolder(Object bean, CamelContext context) {
        this(bean, new BeanInfo(context, bean.getClass()));
    }

    public ConstantBeanHolder(Object bean, CamelContext context, ParameterMappingStrategy parameterMappingStrategy) {
        this(bean, new BeanInfo(context, bean.getClass(), parameterMappingStrategy));
    }

    public String toString() {
        return ObjectHelper.className(this.bean) + "(" + ObjectHelper.getIdentityHashCode(this.bean) + ")";
    }

    @Override
    public Object getBean() {
        return this.bean;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return null;
    }
}

