/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements AugmentedPropertyNameAwarePropertiesParser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        return this.parseUri(text, properties, prefixToken, suffixToken, null, null, false);
    }

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) throws IllegalArgumentException {
        ParsingContext context = new ParsingContext(properties, prefixToken, suffixToken, propertyPrefix, propertySuffix, fallbackToUnaugmentedProperty);
        return context.parse(text);
    }

    @Override
    public String parseProperty(String key, String value, Properties properties) {
        return value;
    }

    private static final class Property {
        private final int beginIndex;
        private final int endIndex;
        private final String key;
        private final String value;

        private Property(int beginIndex, int endIndex, String key, String value) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.key = key;
            this.value = value;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private final class ParsingContext {
        private final Properties properties;
        private final String prefixToken;
        private final String suffixToken;
        private final String propertyPrefix;
        private final String propertySuffix;
        private final boolean fallbackToUnaugmentedProperty;

        public ParsingContext(Properties properties, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) {
            this.properties = properties;
            this.prefixToken = prefixToken;
            this.suffixToken = suffixToken;
            this.propertyPrefix = propertyPrefix;
            this.propertySuffix = propertySuffix;
            this.fallbackToUnaugmentedProperty = fallbackToUnaugmentedProperty;
        }

        public String parse(String input) {
            return this.doParse(input, new HashSet<String>());
        }

        private String doParse(String input, Set<String> replacedPropertyKeys) {
            Property property;
            String answer = input;
            while ((property = this.readProperty(answer)) != null) {
                if (replacedPropertyKeys.contains(property.getKey())) {
                    throw new IllegalArgumentException("Circular reference detected with key [" + property.getKey() + "] from text: " + input);
                }
                HashSet<String> newReplaced = new HashSet<String>(replacedPropertyKeys);
                newReplaced.add(property.getKey());
                String before = answer.substring(0, property.getBeginIndex());
                String after = answer.substring(property.getEndIndex());
                answer = before + this.doParse(property.getValue(), newReplaced) + after;
            }
            return answer;
        }

        private Property readProperty(String input) {
            int suffix = this.getSuffixIndex(input);
            if (suffix == -1) {
                if (this.getMatchingPrefixIndex(input, input.length()) != -1) {
                    throw new IllegalArgumentException(String.format("Missing %s from the text: %s", this.suffixToken, input));
                }
                return null;
            }
            int prefix = this.getMatchingPrefixIndex(input, suffix);
            if (prefix == -1) {
                throw new IllegalArgumentException(String.format("Missing %s from the text: %s", this.prefixToken, input));
            }
            String key = input.substring(prefix + this.prefixToken.length(), suffix);
            String value = this.getPropertyValue(key, input);
            return new Property(prefix, suffix + this.suffixToken.length(), key, value);
        }

        private int getSuffixIndex(String input) {
            int index = -1;
            while ((index = input.indexOf(this.suffixToken, index + 1)) != -1 && this.isQuoted(input, index, this.suffixToken)) {
            }
            return index;
        }

        private int getMatchingPrefixIndex(String input, int suffixIndex) {
            int index = suffixIndex;
            while ((index = input.lastIndexOf(this.prefixToken, index - 1)) != -1 && this.isQuoted(input, index, this.prefixToken)) {
            }
            return index;
        }

        private boolean isQuoted(String input, int index, String token) {
            int beforeIndex = index - 1;
            int afterIndex = index + token.length();
            if (beforeIndex >= 0 && afterIndex < input.length()) {
                char after;
                char before = input.charAt(beforeIndex);
                return before == (after = input.charAt(afterIndex)) && (before == '\'' || before == '\"');
            }
            return false;
        }

        private String getPropertyValue(String key, String input) {
            String augmentedKey = this.getAugmentedKey(key);
            boolean shouldFallback = this.fallbackToUnaugmentedProperty && !key.equals(augmentedKey);
            String value = this.doGetPropertyValue(augmentedKey);
            if (value == null && shouldFallback) {
                DefaultPropertiesParser.this.log.debug("Property with key [{}] not found, attempting with unaugmented key: {}", (Object)augmentedKey, (Object)key);
                value = this.doGetPropertyValue(key);
            }
            if (value == null) {
                StringBuilder esb = new StringBuilder();
                esb.append("Property with key [").append(augmentedKey).append("] ");
                if (shouldFallback) {
                    esb.append("(and original key [").append(key).append("]) ");
                }
                esb.append("not found in properties from text: ").append(input);
                throw new IllegalArgumentException(esb.toString());
            }
            return value;
        }

        private String getAugmentedKey(String key) {
            String augmentedKey = key;
            if (this.propertyPrefix != null) {
                DefaultPropertiesParser.this.log.debug("Augmenting property key [{}] with prefix: {}", (Object)key, (Object)this.propertyPrefix);
                augmentedKey = this.propertyPrefix + augmentedKey;
            }
            if (this.propertySuffix != null) {
                DefaultPropertiesParser.this.log.debug("Augmenting property key [{}] with suffix: {}", (Object)key, (Object)this.propertySuffix);
                augmentedKey = augmentedKey + this.propertySuffix;
            }
            return augmentedKey;
        }

        private String doGetPropertyValue(String key) {
            String value = System.getProperty(key);
            if (value != null) {
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            } else if (this.properties != null) {
                value = this.properties.getProperty(key);
            }
            return DefaultPropertiesParser.this.parseProperty(key, value, this.properties);
        }
    }
}

