/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.dispatch.Dispatcher;
import org.apache.felix.http.base.internal.handler.HandlerRegistry;
import org.apache.felix.http.base.internal.handler.HttpServicePlugin;
import org.apache.felix.http.base.internal.listener.HttpSessionAttributeListenerManager;
import org.apache.felix.http.base.internal.listener.HttpSessionListenerManager;
import org.apache.felix.http.base.internal.listener.ServletContextAttributeListenerManager;
import org.apache.felix.http.base.internal.listener.ServletRequestAttributeListenerManager;
import org.apache.felix.http.base.internal.listener.ServletRequestListenerManager;
import org.apache.felix.http.base.internal.service.HttpServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpServiceController {
    private static final String FELIX_HTTP_SHARED_SERVLET_CONTEXT_ATTRIBUTES = "org.apache.felix.http.shared_servlet_context_attributes";
    private final BundleContext bundleContext;
    private final HandlerRegistry registry;
    private final Dispatcher dispatcher;
    private final Hashtable<String, Object> serviceProps;
    private final ServletContextAttributeListenerManager contextAttributeListener;
    private final ServletRequestListenerManager requestListener;
    private final ServletRequestAttributeListenerManager requestAttributeListener;
    private final HttpSessionListenerManager sessionListener;
    private final HttpSessionAttributeListenerManager sessionAttributeListener;
    private final boolean sharedContextAttributes;
    private final HttpServicePlugin plugin;
    private ServiceRegistration serviceReg;

    public HttpServiceController(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.registry = new HandlerRegistry();
        this.dispatcher = new Dispatcher(this.registry);
        this.serviceProps = new Hashtable();
        this.contextAttributeListener = new ServletContextAttributeListenerManager(bundleContext);
        this.requestListener = new ServletRequestListenerManager(bundleContext);
        this.requestAttributeListener = new ServletRequestAttributeListenerManager(bundleContext);
        this.sessionListener = new HttpSessionListenerManager(bundleContext);
        this.sessionAttributeListener = new HttpSessionAttributeListenerManager(bundleContext);
        this.sharedContextAttributes = this.getBoolean(FELIX_HTTP_SHARED_SERVLET_CONTEXT_ATTRIBUTES);
        this.plugin = new HttpServicePlugin(bundleContext, this.registry);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ServletContextAttributeListenerManager getContextAttributeListener() {
        return this.contextAttributeListener;
    }

    public ServletRequestListenerManager getRequestListener() {
        return this.requestListener;
    }

    public ServletRequestAttributeListenerManager getRequestAttributeListener() {
        return this.requestAttributeListener;
    }

    public HttpSessionListenerManager getSessionListener() {
        return this.sessionListener;
    }

    public HttpSessionAttributeListenerManager getSessionAttributeListener() {
        return this.sessionAttributeListener;
    }

    public void setProperties(Hashtable<String, Object> props) {
        this.serviceProps.clear();
        this.serviceProps.putAll(props);
        if (this.serviceReg != null) {
            this.serviceReg.setProperties(this.serviceProps);
        }
    }

    public void register(ServletContext servletContext) {
        this.contextAttributeListener.open();
        this.requestListener.open();
        this.requestAttributeListener.open();
        this.sessionListener.open();
        this.sessionAttributeListener.open();
        this.plugin.register();
        HttpServiceFactory factory = new HttpServiceFactory(servletContext, this.registry, this.contextAttributeListener, this.sharedContextAttributes);
        String[] ifaces = new String[]{HttpService.class.getName(), ExtHttpService.class.getName()};
        this.serviceReg = this.bundleContext.registerService(ifaces, (Object)factory, this.serviceProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        if (this.serviceReg == null) {
            return;
        }
        this.sessionAttributeListener.close();
        this.sessionListener.close();
        this.contextAttributeListener.close();
        this.requestListener.close();
        this.requestAttributeListener.close();
        this.plugin.unregister();
        try {
            this.serviceReg.unregister();
            this.registry.removeAll();
        }
        finally {
            this.serviceReg = null;
        }
    }

    private boolean getBoolean(String property) {
        String prop = this.bundleContext.getProperty(property);
        return prop != null ? Boolean.valueOf(prop) : false;
    }
}

