/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.feed;

import java.util.Date;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedPollingConsumer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.util.ObjectHelper;

public abstract class FeedEndpoint
extends DefaultPollingEndpoint {
    protected String feedUri;
    protected boolean splitEntries = true;
    protected Date lastUpdate;
    protected boolean filter = true;
    private boolean feedHeader = true;
    private boolean sortEntries;
    private boolean throttleEntries = true;

    public FeedEndpoint() {
    }

    public FeedEndpoint(String endpointUri, FeedComponent component, String feedUri) {
        super(endpointUri, (Component)component);
        this.feedUri = feedUri;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("FeedProducer is not implemented");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.feedUri, (String)"feedUri");
        FeedPollingConsumer answer = this.isSplitEntries() ? this.createEntryPollingConsumer(this, processor, this.filter, this.lastUpdate, this.throttleEntries) : this.createPollingConsumer(this, processor);
        answer.setDelay(60000L);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected abstract FeedPollingConsumer createPollingConsumer(FeedEndpoint var1, Processor var2) throws Exception;

    protected abstract FeedPollingConsumer createEntryPollingConsumer(FeedEndpoint var1, Processor var2, boolean var3, Date var4, boolean var5) throws Exception;

    protected Exchange createExchangeWithFeedHeader(Object feed, String header) {
        Exchange exchange = this.createExchange();
        if (this.isFeedHeader()) {
            exchange.getIn().setHeader(header, feed);
        }
        return exchange;
    }

    public abstract Exchange createExchange(Object var1);

    public abstract Exchange createExchange(Object var1, Object var2);

    protected String createEndpointUri() {
        return "atom:" + this.feedUri;
    }

    public String getEndpointKey() {
        return this.getEndpointUri();
    }

    public String getFeedUri() {
        return this.feedUri;
    }

    public void setFeedUri(String feedUri) {
        this.feedUri = feedUri;
    }

    public boolean isSplitEntries() {
        return this.splitEntries;
    }

    public void setSplitEntries(boolean splitEntries) {
        this.splitEntries = splitEntries;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void setFeedHeader(boolean feedHeader) {
        this.feedHeader = feedHeader;
    }

    public boolean isFeedHeader() {
        return this.feedHeader;
    }

    public void setSortEntries(boolean sortEntries) {
        this.sortEntries = sortEntries;
    }

    public boolean isSortEntries() {
        return this.sortEntries;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public void setThrottleEntries(boolean throttleEntries) {
        this.throttleEntries = throttleEntries;
    }

    public boolean isThrottleEntries() {
        return this.throttleEntries;
    }
}

