/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.gravia.repository.Namespace100;
import org.jboss.gravia.repository.RepositoryStorageException;
import org.jboss.gravia.repository.RepositoryWriter;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.spi.AttributeValueHandler;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public abstract class AbstractRepositoryXMLWriter
implements RepositoryWriter {
    private final XMLStreamWriter writer;

    public AbstractRepositoryXMLWriter(OutputStream outputStream) {
        IllegalArgumentAssertion.assertNotNull((Object)outputStream, (String)"outputStream");
        this.writer = this.createXMLStreamWriter(outputStream);
    }

    protected abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1);

    @Override
    public void writeRepositoryElement(Map<String, String> attributes) {
        try {
            this.writer.writeStartDocument();
            this.writer.setDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
            this.writer.writeStartElement(Namespace100.Element.REPOSITORY.getLocalName());
            this.writer.writeDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writer.writeAttribute(entry.getKey(), entry.getValue());
            }
        }
        catch (XMLStreamException ex) {
            throw new RepositoryStorageException("Cannot write repository element", ex);
        }
    }

    @Override
    public void writeResource(Resource resource) {
        try {
            AbstractRepositoryXMLWriter.writeResource(this.writer, resource, null);
        }
        catch (IOException ex) {
            throw new RepositoryStorageException("Cannot write resource", ex);
        }
    }

    public static void writeResource(XMLStreamWriter writer, Resource resource, RepositoryWriter.ContentHandler contentHandler) throws IOException {
        try {
            writer.writeStartElement(Namespace100.Element.RESOURCE.getLocalName());
            for (Capability cap : resource.getCapabilities(null)) {
                if ("gravia.content".equals(cap.getNamespace())) {
                    AbstractRepositoryXMLWriter.writeContentCapability(writer, (ContentCapability)cap.adapt(ContentCapability.class), contentHandler);
                    continue;
                }
                AbstractRepositoryXMLWriter.writeCapability(writer, cap);
            }
            for (Requirement req : resource.getRequirements(null)) {
                AbstractRepositoryXMLWriter.writeRequirement(writer, req);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Cannot initialize repository writer", ex);
        }
    }

    public static void writeCapability(XMLStreamWriter writer, Capability cap) throws IOException, XMLStreamException {
        writer.writeStartElement(Namespace100.Element.CAPABILITY.getLocalName());
        writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), cap.getNamespace());
        AbstractRepositoryXMLWriter.writeAttributes(writer, cap.getAttributes());
        AbstractRepositoryXMLWriter.writeDirectives(writer, cap.getDirectives());
        writer.writeEndElement();
    }

    public static void writeContentCapability(XMLStreamWriter writer, ContentCapability ccap, RepositoryWriter.ContentHandler contentHandler) throws IOException, XMLStreamException {
        writer.writeStartElement(Namespace100.Element.CAPABILITY.getLocalName());
        writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), ccap.getNamespace());
        AbstractRepositoryXMLWriter.writeAttributes(writer, contentHandler != null ? contentHandler.process(ccap) : ccap.getAttributes());
        AbstractRepositoryXMLWriter.writeDirectives(writer, ccap.getDirectives());
        writer.writeEndElement();
    }

    public static void writeRequirement(XMLStreamWriter writer, Requirement req) throws XMLStreamException {
        writer.writeStartElement(Namespace100.Element.REQUIREMENT.getLocalName());
        writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), req.getNamespace());
        AbstractRepositoryXMLWriter.writeAttributes(writer, req.getAttributes());
        AbstractRepositoryXMLWriter.writeDirectives(writer, req.getDirectives());
        writer.writeEndElement();
    }

    @Override
    public void close() {
        try {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException ex) {
            throw new RepositoryStorageException("Cannot write repository element", ex);
        }
    }

    private static void writeAttributes(XMLStreamWriter writer, Map<String, Object> attributes) throws XMLStreamException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            AttributeValueHandler.AttributeValue attval = AttributeValueHandler.AttributeValue.create((Object)entry.getValue());
            writer.writeStartElement(Namespace100.Element.ATTRIBUTE.getLocalName());
            writer.writeAttribute(Namespace100.Attribute.NAME.getLocalName(), entry.getKey());
            if (attval.isListType()) {
                writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), attval.getValueString());
                writer.writeAttribute(Namespace100.Attribute.TYPE.getLocalName(), "List<" + attval.getType() + ">");
            } else {
                writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), attval.getValueString());
                if (attval.getType() != AttributeValueHandler.Type.String) {
                    writer.writeAttribute(Namespace100.Attribute.TYPE.getLocalName(), attval.getType().toString());
                }
            }
            writer.writeEndElement();
        }
    }

    private static void writeDirectives(XMLStreamWriter writer, Map<String, String> directives) throws XMLStreamException {
        for (Map.Entry<String, String> entry : directives.entrySet()) {
            writer.writeStartElement(Namespace100.Element.DIRECTIVE.getLocalName());
            writer.writeAttribute(Namespace100.Attribute.NAME.getLocalName(), entry.getKey());
            writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), entry.getValue());
            writer.writeEndElement();
        }
    }
}

