/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class RepositoryContentHelper {
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";

    private RepositoryContentHelper() {
    }

    public static String getDigest(InputStream input) throws IOException, NoSuchAlgorithmException {
        return RepositoryContentHelper.getDigest(input, DEFAULT_DIGEST_ALGORITHM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDigest(InputStream input, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        try {
            int nread = 0;
            byte[] dataBytes = new byte[1024];
            while ((nread = input.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
        }
        finally {
            input.close();
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : md.digest()) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }
}

