/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.camel.component.netty.CamelNettyThreadNameDeterminer;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public final class NettyClientBossPoolBuilder {
    private String name = "NettyClientBoss";
    private String pattern;
    private int bossCount = 1;
    private Timer timer;

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public NettyClientBossPoolBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public NettyClientBossPoolBuilder withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public NettyClientBossPoolBuilder withBossCount(int bossCount) {
        this.setBossCount(bossCount);
        return this;
    }

    public NettyClientBossPoolBuilder withTimer(Timer timer) {
        this.setTimer(timer);
        return this;
    }

    BossPool build() {
        return new NioClientBossPool((Executor)Executors.newCachedThreadPool(), this.bossCount, this.timer, (ThreadNameDeterminer)new CamelNettyThreadNameDeterminer(this.pattern, this.name));
    }
}

