/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.security.auth.Subject;
import org.apache.activemq.broker.jmx.MBeanInfo;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.util.AuditLogService;
import org.apache.activemq.broker.util.JMXAuditLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedMBean
extends StandardMBean {
    private static final Map<String, Class<?>> primitives;
    private static final Logger LOG;
    private static boolean audit;
    private static AuditLogService auditLog;

    public static void registerMBean(ManagementContext context, Object object, ObjectName objectName) throws Exception {
        String mbeanName = object.getClass().getName() + "MBean";
        for (Class<?> c : object.getClass().getInterfaces()) {
            if (!mbeanName.equals(c.getName())) continue;
            context.registerMBean(new AnnotatedMBean(object, c), objectName);
            return;
        }
        context.registerMBean(object, objectName);
    }

    public <T> AnnotatedMBean(T impl, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(impl, mbeanInterface);
    }

    protected AnnotatedMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        MBeanInfo d;
        String descr = info.getDescription();
        Method m = AnnotatedMBean.getMethod(this.getMBeanInterface(), "get" + info.getName().substring(0, 1).toUpperCase() + info.getName().substring(1), new String[0]);
        if (m == null) {
            m = AnnotatedMBean.getMethod(this.getMBeanInterface(), "is" + info.getName().substring(0, 1).toUpperCase() + info.getName().substring(1), new String[0]);
        }
        if (m == null) {
            m = AnnotatedMBean.getMethod(this.getMBeanInterface(), "does" + info.getName().substring(0, 1).toUpperCase() + info.getName().substring(1), new String[0]);
        }
        if (m != null && (d = m.getAnnotation(MBeanInfo.class)) != null) {
            descr = d.value();
        }
        return descr;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        MBeanInfo d;
        String descr = op.getDescription();
        Method m = this.getMethod(op);
        if (m != null && (d = m.getAnnotation(MBeanInfo.class)) != null) {
            descr = d.value();
        }
        return descr;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int paramNo) {
        String name = param.getName();
        Method m = this.getMethod(op);
        if (m != null) {
            for (Annotation a : m.getParameterAnnotations()[paramNo]) {
                if (!MBeanInfo.class.isInstance(a)) continue;
                name = ((MBeanInfo)MBeanInfo.class.cast(a)).value();
            }
        }
        return name;
    }

    private Method getMethod(MBeanOperationInfo op) {
        MBeanParameterInfo[] params = op.getSignature();
        String[] paramTypes = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getType();
        }
        return AnnotatedMBean.getMethod(this.getMBeanInterface(), op.getName(), paramTypes);
    }

    private static Method getMethod(Class<?> mbean, String method, String ... params) {
        try {
            ClassLoader loader = mbean.getClassLoader();
            Class[] paramClasses = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramClasses[i] = primitives.get(params[i]);
                if (paramClasses[i] != null) continue;
                paramClasses[i] = Class.forName(params[i], false, loader);
            }
            return mbean.getMethod(method, paramClasses);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
        if (audit) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            String caller = "anonymous";
            if (subject != null) {
                caller = "";
                for (Principal principal : subject.getPrincipals()) {
                    caller = caller + principal.getName() + " ";
                }
            }
            JMXAuditLogEntry entry = new JMXAuditLogEntry();
            entry.setUser(caller);
            entry.setTimestamp(System.currentTimeMillis());
            entry.setOperation(this.getMBeanInfo().getClassName() + "." + s);
            entry.getParameters().put("arguments", objects);
            auditLog.log(entry);
        }
        return super.invoke(s, objects, strings);
    }

    static {
        Class[] p;
        primitives = new HashMap();
        LOG = LoggerFactory.getLogger((String)"org.apache.activemq.audit");
        for (Class c : p = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE}) {
            primitives.put(c.getName(), c);
        }
        audit = "true".equalsIgnoreCase(System.getProperty("org.apache.activemq.audit"));
        if (audit) {
            auditLog = AuditLogService.getAuditLog();
        }
    }
}

