/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExpression
implements Serializable {
    private XPathEvaluator evaluator;
    private Expression expression;
    private SlotManager stackFrameMap;
    private int numberOfExternalVariables;

    protected XPathExpression(XPathEvaluator evaluator, Expression exp) {
        this.expression = exp;
        this.evaluator = evaluator;
    }

    protected void setStackFrameMap(SlotManager map, int numberOfExternalVariables) {
        this.stackFrameMap = map;
        this.numberOfExternalVariables = numberOfExternalVariables;
    }

    public XPathDynamicContext createDynamicContext() {
        XPathContextMajor context = new XPathContextMajor(null, this.expression.getExecutable());
        context.openStackFrame(this.stackFrameMap);
        return new XPathDynamicContext(this.evaluator.getStaticContext().getRequiredContextItemType(), context, this.stackFrameMap);
    }

    public XPathDynamicContext createDynamicContext(Item contextItem) throws XPathException {
        this.checkContextItemType(contextItem);
        XPathContextMajor context = new XPathContextMajor(contextItem, this.expression.getExecutable());
        context.openStackFrame(this.stackFrameMap);
        return new XPathDynamicContext(this.evaluator.getStaticContext().getRequiredContextItemType(), context, this.stackFrameMap);
    }

    public XPathDynamicContext createDynamicContext(Controller controller, Item contextItem) throws XPathException {
        this.checkContextItemType(contextItem);
        if (controller == null) {
            return this.createDynamicContext(contextItem);
        }
        XPathContextMajor context = controller.newXPathContext();
        context.openStackFrame(this.stackFrameMap);
        XPathDynamicContext dc = new XPathDynamicContext(this.evaluator.getStaticContext().getRequiredContextItemType(), context, this.stackFrameMap);
        if (contextItem != null) {
            dc.setContextItem(contextItem);
        }
        return dc;
    }

    private void checkContextItemType(Item contextItem) throws XPathException {
        ItemType type;
        if (contextItem != null && !(type = this.evaluator.getStaticContext().getRequiredContextItemType()).matchesItem(contextItem, false, this.evaluator.getConfiguration())) {
            throw new XPathException("Supplied context item does not match required context item type " + type.toString());
        }
    }

    public SequenceIterator<? extends Item> iterate(XPathDynamicContext context) throws XPathException {
        context.checkExternalVariables(this.stackFrameMap, this.numberOfExternalVariables);
        return this.expression.iterate(context.getXPathContextObject());
    }

    public List<Item> evaluate(XPathDynamicContext context) throws XPathException {
        Item item;
        SequenceIterator<? extends Item> iter = this.expression.iterate(context.getXPathContextObject());
        ArrayList<Item> list = new ArrayList<Item>(20);
        while ((item = iter.next()) != null) {
            list.add(item);
        }
        return list;
    }

    public Item evaluateSingle(XPathDynamicContext context) throws XPathException {
        return this.expression.iterate(context.getXPathContextObject()).next();
    }

    public boolean effectiveBooleanValue(XPathDynamicContext context) throws XPathException {
        return this.expression.effectiveBooleanValue(context.getXPathContextObject());
    }

    public List<Object> evaluate(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext dynamicContext = this.createDynamicContext(origin);
        SequenceIterator<? extends Item> iter = this.iterate(dynamicContext);
        SequenceExtent<? extends Item> extent = new SequenceExtent<Item>(iter);
        List result = (List)PJConverter.ToCollection.INSTANCE.convert(extent, List.class, dynamicContext.getXPathContextObject());
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public Object evaluateSingle(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext context = this.createDynamicContext(origin);
        SequenceIterator<? extends Item> iterator = this.iterate(context);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return SequenceTool.convertToJava(item);
    }

    public SequenceIterator rawIterator(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext context = this.createDynamicContext(origin);
        return this.iterate(context);
    }

    public Expression getInternalExpression() {
        return this.expression;
    }
}

