/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.net.ftp.FTPFile;

public class FtpComponent
extends RemoteFileComponent<FTPFile> {
    public FtpComponent() {
        this.setEndpointClass(FtpEndpoint.class);
    }

    public FtpComponent(CamelContext context) {
        super(context);
        this.setEndpointClass(FtpEndpoint.class);
    }

    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpConfiguration config = new FtpConfiguration(new URI(baseUri));
        FtpEndpoint<FTPFile> answer = new FtpEndpoint<FTPFile>(uri, (RemoteFileComponent<FTPFile>)this, (RemoteFileConfiguration)config);
        this.extractAndSetFtpClientConfigParameters(parameters, answer);
        this.extractAndSetFtpClientParameters(parameters, answer);
        return answer;
    }

    protected String getBaseUri(String uri) {
        String baseUri = uri;
        if (uri.indexOf("?") != -1) {
            baseUri = uri.substring(0, uri.indexOf("?"));
        }
        return baseUri;
    }

    protected void extractAndSetFtpClientConfigParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (IntrospectionSupport.hasProperties(parameters, (String)"ftpClientConfig.")) {
            Map param = IntrospectionSupport.extractProperties(parameters, (String)"ftpClientConfig.");
            answer.setFtpClientConfigParameters(param);
        }
    }

    protected void extractAndSetFtpClientParameters(Map<String, Object> parameters, FtpEndpoint<FTPFile> answer) {
        if (IntrospectionSupport.hasProperties(parameters, (String)"ftpClient.")) {
            Map param = IntrospectionSupport.extractProperties(parameters, (String)"ftpClient.");
            answer.setFtpClientParameters(param);
        }
    }

    protected void afterPropertiesSet(GenericFileEndpoint<FTPFile> endpoint) throws Exception {
    }
}

