/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Proxy;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.SftpComponent;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpConsumer;
import org.apache.camel.component.file.remote.SftpOperations;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(scheme="sftp", consumerClass=SftpConsumer.class)
public class SftpEndpoint
extends RemoteFileEndpoint<ChannelSftp.LsEntry> {
    Proxy proxy;

    public SftpEndpoint() {
    }

    public SftpEndpoint(String uri, SftpComponent component, RemoteFileConfiguration configuration) {
        super(uri, component, configuration);
    }

    @Override
    public SftpConfiguration getConfiguration() {
        return (SftpConfiguration)this.configuration;
    }

    @Override
    protected RemoteFileConsumer<ChannelSftp.LsEntry> buildConsumer(Processor processor) {
        return new SftpConsumer(this, processor, this.createRemoteFileOperations());
    }

    @Override
    protected GenericFileProducer<ChannelSftp.LsEntry> buildProducer() {
        return new RemoteFileProducer<ChannelSftp.LsEntry>(this, this.createRemoteFileOperations());
    }

    @Override
    public RemoteFileOperations<ChannelSftp.LsEntry> createRemoteFileOperations() {
        SftpOperations operations = new SftpOperations(this.proxy);
        operations.setEndpoint(this);
        return operations;
    }

    public String getScheme() {
        return "sftp";
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

