/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.LinkedList;
import org.apache.felix.scr.impl.Activator;

class ComponentActorThread
implements Runnable {
    private static final Runnable TERMINATION_TASK = new Runnable(){

        public void run() {
        }

        public String toString() {
            return "Component Actor Terminator";
        }
    };
    private LinkedList tasks = new LinkedList();

    ComponentActorThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Activator.log(4, null, "Starting ComponentActorThread", null);
        while (true) {
            Runnable task;
            LinkedList linkedList = this.tasks;
            synchronized (linkedList) {
                while (this.tasks.isEmpty()) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                task = (Runnable)this.tasks.removeFirst();
            }
            try {
                if (task == TERMINATION_TASK) {
                    Activator.log(4, null, "Shutting down ComponentActorThread", null);
                    return;
                }
                Activator.log(4, null, "Running task: " + task, null);
                task.run();
                continue;
            }
            catch (Throwable t) {
                Activator.log(1, null, "Unexpected problem executing task " + task, t);
                continue;
            }
            finally {
                linkedList = this.tasks;
                synchronized (linkedList) {
                    this.tasks.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        this.schedule(TERMINATION_TASK);
        LinkedList linkedList = this.tasks;
        synchronized (linkedList) {
            while (!this.tasks.isEmpty()) {
                try {
                    this.tasks.wait();
                }
                catch (InterruptedException e) {
                    Activator.log(1, null, "Interrupted exception waiting for queue to empty", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable task) {
        LinkedList linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            Activator.log(4, null, "Adding task [" + task + "] as #" + this.tasks.size() + " in the queue", null);
            this.tasks.notifyAll();
        }
    }
}

