/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.manager.RefPair;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractComponentManager
implements Component,
SimpleLogger {
    private long m_componentId;
    private volatile State m_state;
    private final ComponentMetadata m_componentMetadata;
    private final ComponentMethods m_componentMethods;
    private final List m_dependencyManagers;
    private boolean m_dependencyManagersInitialized;
    private final AtomicReference m_dependencies_map;
    private BundleComponentActivator m_activator;
    private final AtomicReference m_serviceRegistration;
    private final ReentrantLock m_stateLock;
    private long m_timeout = 5000L;
    protected volatile boolean enabled;
    protected volatile CountDownLatch enabledLatch;
    private final Object enabledLatchLock = new Object();
    private volatile boolean disposed;
    private static final AtomicLong taskCounter = new AtomicLong();

    protected AbstractComponentManager(BundleComponentActivator activator, ComponentMetadata metadata, ComponentMethods componentMethods) {
        this.m_activator = activator;
        this.m_componentMetadata = metadata;
        this.m_componentMethods = componentMethods;
        this.m_componentId = -1L;
        this.m_state = Disabled.getInstance();
        this.m_dependencyManagers = this.loadDependencyManagers(metadata);
        this.m_stateLock = new ReentrantLock(true);
        this.m_dependencies_map = new AtomicReference();
        this.m_serviceRegistration = new AtomicReference();
        if (this.isLogEnabled(4)) {
            this.log(4, "Component {0} created: DS={1}, implementation={2}, immediate={3}, default-enabled={4}, factory={5}, configuration-policy={6}, activate={7}, deactivate={8}, modified={9} configuration-pid={10}", new Object[]{metadata.getName(), new Integer(metadata.getNamespaceCode()), metadata.getImplementationClassName(), metadata.isImmediate(), metadata.isEnabled(), metadata.getFactoryIdentifier(), metadata.getConfigurationPolicy(), metadata.getActivate(), metadata.getDeactivate(), metadata.getModified(), metadata.getConfigurationPid()}, null);
            if (metadata.getServiceMetadata() != null) {
                this.log(4, "Component {0} Services: servicefactory={1}, services={2}", new Object[]{metadata.getName(), metadata.getServiceMetadata().isServiceFactory(), Arrays.asList(metadata.getServiceMetadata().getProvides())}, null);
            }
            if (metadata.getProperties() != null) {
                this.log(4, "Component {0} Properties: {1}", new Object[]{metadata.getName(), metadata.getProperties()}, null);
            }
        }
    }

    final void obtainWriteLock(String source) {
        try {
            if (!this.m_stateLock.tryLock(this.m_timeout, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Could not obtain lock");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Could not obtain lock (Reason: " + e + ")");
        }
    }

    final void releaseWriteLock(String source) {
        this.m_stateLock.unlock();
    }

    final boolean isWriteLocked() {
        return this.m_stateLock.getHoldCount() > 0;
    }

    void registerComponentId() {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            this.m_componentId = activator.registerComponentId(this);
        }
    }

    void unregisterComponentId() {
        if (this.m_componentId >= 0L) {
            BundleComponentActivator activator = this.getActivator();
            if (activator != null) {
                activator.unregisterComponentId(this);
            }
            this.m_componentId = -1L;
        }
    }

    public final void enable() {
        this.enable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enable(boolean async) {
        if (this.enabled) {
            return;
        }
        try {
            Object object = this.enabledLatchLock;
            synchronized (object) {
                if (this.enabledLatch != null) {
                    this.enabledLatch.await();
                }
                this.enabledLatch = new CountDownLatch(1);
            }
            this.enableInternal();
            if (!async) {
                this.activateInternal();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!async) {
                this.enabledLatch.countDown();
            }
            this.enabled = true;
        }
        if (async) {
            this.m_activator.schedule(new Runnable(){
                long count = AbstractComponentManager.access$000().incrementAndGet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AbstractComponentManager.this.activateInternal();
                    }
                    finally {
                        AbstractComponentManager.this.enabledLatch.countDown();
                    }
                }

                public String toString() {
                    return "Async Activate: " + AbstractComponentManager.this.getComponentMetadata().getName() + " id: " + this.count;
                }
            });
        }
    }

    public final void disable() {
        this.disable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disable(boolean async) {
        if (!this.enabled) {
            return;
        }
        try {
            Object object = this.enabledLatchLock;
            synchronized (object) {
                if (this.enabledLatch != null) {
                    this.enabledLatch.await();
                }
                this.enabledLatch = new CountDownLatch(1);
            }
            if (!async) {
                this.deactivateInternal(1, true);
            }
            this.disableInternal();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!async) {
                this.enabledLatch.countDown();
            }
            this.enabled = false;
        }
        if (async) {
            this.m_activator.schedule(new Runnable(){
                long count = AbstractComponentManager.access$000().incrementAndGet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        AbstractComponentManager.this.deactivateInternal(1, true);
                    }
                    finally {
                        AbstractComponentManager.this.enabledLatch.countDown();
                    }
                }

                public String toString() {
                    return "Async Deactivate: " + AbstractComponentManager.this.getComponentMetadata().getName() + " id: " + this.count;
                }
            });
        }
    }

    abstract Object getInstance();

    void dispose() {
        this.dispose(5);
    }

    public void dispose(int reason) {
        this.disposed = true;
        this.disposeInternal(reason);
    }

    public long getId() {
        return this.m_componentId;
    }

    public String getName() {
        return this.m_componentMetadata.getName();
    }

    public Bundle getBundle() {
        BundleContext context;
        BundleComponentActivator activator = this.getActivator();
        if (activator != null && (context = activator.getBundleContext()) != null) {
            try {
                return context.getBundle();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getClassName() {
        return this.m_componentMetadata.getImplementationClassName();
    }

    public String getFactory() {
        return this.m_componentMetadata.getFactoryIdentifier();
    }

    public Reference[] getReferences() {
        if (this.m_dependencyManagers != null && this.m_dependencyManagers.size() > 0) {
            return this.m_dependencyManagers.toArray(new Reference[this.m_dependencyManagers.size()]);
        }
        return null;
    }

    public boolean isImmediate() {
        return this.m_componentMetadata.isImmediate();
    }

    public boolean isDefaultEnabled() {
        return this.m_componentMetadata.isEnabled();
    }

    public String getActivate() {
        return this.m_componentMetadata.getActivate();
    }

    public boolean isActivateDeclared() {
        return this.m_componentMetadata.isActivateDeclared();
    }

    public String getDeactivate() {
        return this.m_componentMetadata.getDeactivate();
    }

    public boolean isDeactivateDeclared() {
        return this.m_componentMetadata.isDeactivateDeclared();
    }

    public String getModified() {
        return this.m_componentMetadata.getModified();
    }

    public String getConfigurationPolicy() {
        return this.m_componentMetadata.getConfigurationPolicy();
    }

    public String getConfigurationPid() {
        return this.m_componentMetadata.getConfigurationPid();
    }

    public boolean isConfigurationPidDeclared() {
        return this.m_componentMetadata.isConfigurationPidDeclared();
    }

    public boolean isServiceFactory() {
        return this.m_componentMetadata.getServiceMetadata() != null && this.m_componentMetadata.getServiceMetadata().isServiceFactory();
    }

    public String[] getServices() {
        if (this.m_componentMetadata.getServiceMetadata() != null) {
            return this.m_componentMetadata.getServiceMetadata().getProvides();
        }
        return null;
    }

    final void enableInternal() {
        this.m_state.enable(this);
    }

    final boolean activateInternal() {
        return this.m_state.activate(this);
    }

    final void deactivateInternal(int reason, boolean disable) {
        this.m_state.deactivate(this, reason, disable);
    }

    final void disableInternal() {
        this.m_state.disable(this);
    }

    public final void disposeInternal(int reason) {
        this.m_state.dispose(this, reason);
    }

    final ServiceReference getServiceReference() {
        State state = this.m_state;
        try {
            return state.getServiceReference(this);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    protected abstract boolean createComponent();

    protected abstract void deleteComponent(int var1);

    private Object getService() {
        return this;
    }

    abstract State getSatisfiedState();

    abstract State getActiveState();

    ComponentMethods getComponentMethods() {
        return this.m_componentMethods;
    }

    protected void registerService() {
        if (this.getComponentMetadata().getServiceMetadata() != null) {
            String[] provides = this.getComponentMetadata().getServiceMetadata().getProvides();
            this.registerService(provides);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerService(String[] provides) {
        AtomicReference atomicReference = this.m_serviceRegistration;
        synchronized (atomicReference) {
            ServiceRegistration existing = (ServiceRegistration)this.m_serviceRegistration.get();
            if (existing == null) {
                boolean weWon;
                this.log(4, "registering services", null);
                Dictionary serviceProperties = this.getServiceProperties();
                ServiceRegistration newRegistration = this.getActivator().getBundleContext().registerService(provides, this.getService(), serviceProperties);
                boolean bl = weWon = !this.disposed && this.m_serviceRegistration.compareAndSet(existing, newRegistration);
                if (weWon) {
                    return;
                }
                newRegistration.unregister();
            } else {
                this.log(4, "Existing service registration, not registering", null);
            }
        }
    }

    final void registerComponentService() {
        this.registerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentService() {
        if (!this.disposed || this.m_serviceRegistration.get() != null) {
            AtomicReference atomicReference = this.m_serviceRegistration;
            synchronized (atomicReference) {
                ServiceRegistration sr = (ServiceRegistration)this.m_serviceRegistration.get();
                if (sr != null && this.m_serviceRegistration.compareAndSet(sr, null)) {
                    this.log(4, "Unregistering services", null);
                    sr.unregister();
                } else if (sr == null) {
                    this.log(4, "Service already unregistered", null);
                } else {
                    this.log(4, "Service unregistered concurrently by another thread", null);
                }
            }
        }
    }

    boolean initDependencyManagers() {
        Class implementationObjectClass;
        if (this.m_dependencyManagersInitialized) {
            return true;
        }
        try {
            implementationObjectClass = this.getActivator().getBundleContext().getBundle().loadClass(this.getComponentMetadata().getImplementationClassName());
        }
        catch (ClassNotFoundException e) {
            this.log(1, "Could not load implementation object class", e);
            return false;
        }
        this.m_componentMethods.initComponentMethods(this, this.m_componentMetadata, implementationObjectClass);
        for (DependencyManager dependencyManager : this.m_dependencyManagers) {
            dependencyManager.initBindingMethods(this.m_componentMethods.getBindMethods(dependencyManager.getName()));
        }
        this.m_dependencyManagersInitialized = true;
        return true;
    }

    protected boolean collectDependencies() throws IllegalStateException {
        Map old = (Map)this.m_dependencies_map.get();
        if (old != null) {
            this.log(4, "dependency map already present, do not collect dependencies", null);
            return false;
        }
        this.initDependencyManagers();
        HashMap newDeps = new HashMap();
        for (DependencyManager dependencyManager : this.m_dependencyManagers) {
            if (dependencyManager.prebind(newDeps)) continue;
            this.returnServices(newDeps);
            this.log(4, "Could not get required dependency for dependency manager: {0}", new Object[]{dependencyManager}, null);
            throw new IllegalStateException("Missing dependencies, not satisfied");
        }
        if (!this.setDependencyMap(old, newDeps)) {
            this.returnServices(newDeps);
            this.log(4, "Another thread set the dependency map already present, do not keep collected dependencies", null);
            return false;
        }
        this.log(4, "This thread collected dependencies", null);
        return true;
    }

    protected boolean setDependencyMap(Map old, Map newDeps) {
        return this.m_dependencies_map.compareAndSet(old, newDeps);
    }

    protected void unsetDependencyMap() {
        this.m_dependencies_map.set(null);
    }

    private void returnServices(Map deps) {
        for (Map refs : deps.values()) {
            if (refs == null) continue;
            for (Map.Entry entry : refs.entrySet()) {
                RefPair args = (RefPair)entry.getValue();
                if (args.getServiceObject() == null) continue;
                this.getActivator().getBundleContext().ungetService((ServiceReference)entry.getKey());
            }
        }
    }

    abstract void update(DependencyManager var1, ServiceReference var2);

    abstract void invokeBindMethod(DependencyManager var1, ServiceReference var2);

    abstract void invokeUnbindMethod(DependencyManager var1, ServiceReference var2);

    Map getDependencyMap() {
        return (Map)this.m_dependencies_map.get();
    }

    public BundleComponentActivator getActivator() {
        return this.m_activator;
    }

    boolean isActivatorActive() {
        BundleComponentActivator activator = this.getActivator();
        return activator != null && activator.isActive();
    }

    final ServiceRegistration getServiceRegistration() {
        return (ServiceRegistration)this.m_serviceRegistration.get();
    }

    void clear() {
        if (this.m_activator != null) {
            this.m_activator.unregisterComponentId(this);
            this.m_activator = null;
        }
        this.m_dependencyManagers.clear();
    }

    protected Map getParameterMap() {
        return (Map)this.m_dependencies_map.get();
    }

    public boolean isLogEnabled(int level) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            return activator.isLogEnabled(level);
        }
        return false;
    }

    public void log(int level, String message, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, this.getComponentMetadata(), ex);
        }
    }

    public void log(int level, String message, Object[] arguments, Throwable ex) {
        BundleComponentActivator activator = this.getActivator();
        if (activator != null) {
            activator.log(level, message, arguments, this.getComponentMetadata(), ex);
        }
    }

    public String toString() {
        return "Component: " + this.getName() + " (" + this.getId() + ")";
    }

    private boolean hasServiceRegistrationPermissions() {
        String[] services;
        ServiceMetadata serviceMetadata;
        boolean allowed = true;
        if (System.getSecurityManager() != null && (serviceMetadata = this.getComponentMetadata().getServiceMetadata()) != null && (services = serviceMetadata.getProvides()) != null && services.length > 0) {
            Bundle bundle = this.getBundle();
            for (int i = 0; i < services.length; ++i) {
                ServicePermission perm = new ServicePermission(services[i], "register");
                if (bundle.hasPermission((Object)perm)) continue;
                this.log(4, "Permission to register service {0} is denied", new Object[]{services[i]}, null);
                allowed = false;
            }
        }
        return allowed;
    }

    private List loadDependencyManagers(ComponentMetadata metadata) {
        ArrayList<DependencyManager> depMgrList = new ArrayList<DependencyManager>(metadata.getDependencies().size());
        if (metadata.getDependencies().size() != 0) {
            for (ReferenceMetadata currentdependency : metadata.getDependencies()) {
                DependencyManager depmanager = new DependencyManager(this, currentdependency);
                depMgrList.add(depmanager);
            }
        }
        return depMgrList;
    }

    private void enableDependencyManagers() throws InvalidSyntaxException {
        if (!this.m_componentMetadata.isConfigurationRequired()) {
            Iterator it = this.getDependencyManagers();
            while (it.hasNext()) {
                DependencyManager dm = (DependencyManager)it.next();
                dm.enable();
            }
        }
    }

    protected void updateTargets(Dictionary properties) {
        for (Object o : this.m_dependencyManagers) {
            DependencyManager dependencyManager = (DependencyManager)o;
            dependencyManager.setTargetFilter(properties);
        }
    }

    protected boolean verifyDependencyManagers(Dictionary properties) {
        boolean satisfied = true;
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (!dm.hasGetPermission()) {
                if (dm.isOptional()) {
                    this.log(4, "No permission to get optional dependency: {0}; assuming satisfied", new Object[]{dm.getName()}, null);
                    continue;
                }
                this.log(4, "No permission to get mandatory dependency: {0}; assuming unsatisfied", new Object[]{dm.getName()}, null);
                satisfied = false;
                continue;
            }
            if (dm.isSatisfied()) continue;
            this.log(4, "Dependency not satisfied: {0}", new Object[]{dm.getName()}, null);
            satisfied = false;
        }
        return satisfied;
    }

    Iterator getDependencyManagers() {
        return this.m_dependencyManagers.iterator();
    }

    Iterator getReversedDependencyManagers() {
        ArrayList list = new ArrayList(this.m_dependencyManagers);
        Collections.reverse(list);
        return list.iterator();
    }

    DependencyManager getDependencyManager(String name) {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (!name.equals(dm.getName())) continue;
            return dm;
        }
        return null;
    }

    private void deactivateDependencyManagers() {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.deactivate();
        }
    }

    private void disableDependencyManagers() {
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.unregisterServiceListener();
        }
    }

    public abstract boolean hasConfiguration();

    public abstract Dictionary getProperties();

    public abstract void setServiceProperties(Dictionary var1);

    public Dictionary getServiceProperties() {
        return AbstractComponentManager.copyTo(null, this.getProperties(), false);
    }

    protected static Dictionary copyTo(Dictionary target, Dictionary source) {
        return AbstractComponentManager.copyTo(target, source, true);
    }

    protected static Dictionary copyTo(Dictionary target, Dictionary source, boolean allProps) {
        if (target == null) {
            target = new Hashtable();
        }
        if (source != null && !source.isEmpty()) {
            Enumeration ce = source.keys();
            while (ce.hasMoreElements()) {
                String key = (String)ce.nextElement();
                if (!allProps && key.charAt(0) == '.') continue;
                ((Dictionary)target).put(key, source.get(key));
            }
        }
        return target;
    }

    public ComponentMetadata getComponentMetadata() {
        return this.m_componentMetadata;
    }

    public int getState() {
        return this.m_state.getState();
    }

    protected State state() {
        return this.m_state;
    }

    void changeState(State newState) {
        this.log(4, "State transition : {0} -> {1} : service reg: {2}", new Object[]{this.m_state, newState, this.m_serviceRegistration.get()}, null);
        this.m_state = newState;
    }

    public void setServiceProperties(MethodResult methodResult) {
        if (methodResult.hasResult()) {
            Hashtable serviceProps = methodResult.getResult() == null ? null : new Hashtable(methodResult.getResult());
            this.setServiceProperties(serviceProps);
        }
    }

    static /* synthetic */ AtomicLong access$000() {
        return taskCounter;
    }

    protected static final class Disposed
    extends State {
        private static final Disposed m_inst = new Disposed();

        private Disposed() {
            super("Disposed", 256);
        }

        static State getInstance() {
            return m_inst;
        }

        boolean activate(AbstractComponentManager acm) {
            throw new IllegalStateException("activate: " + this);
        }

        void deactivate(AbstractComponentManager acm, int reason, boolean disable) {
            throw new IllegalStateException("deactivate: " + this);
        }

        void disable(AbstractComponentManager acm) {
            throw new IllegalStateException("disable: " + this);
        }

        void dispose(AbstractComponentManager acm, int reason) {
        }

        void enable(AbstractComponentManager acm) {
            throw new IllegalStateException("enable: " + this);
        }
    }

    protected static final class FactoryInstance
    extends Satisfied {
        private static final FactoryInstance m_inst = new FactoryInstance();

        private FactoryInstance() {
            super("FactoryInstance", 16);
        }

        static State getInstance() {
            return m_inst;
        }

        Object getService(ImmediateComponentManager dcm) {
            return dcm.getInstance();
        }

        void ungetService(ImmediateComponentManager dcm) {
            dcm.deleteComponent(0);
            dcm.changeState(Registered.getInstance());
        }

        void deactivate(AbstractComponentManager acm, int reason, boolean disable) {
            acm.disposeInternal(reason);
        }
    }

    protected static final class Factory
    extends Satisfied {
        private static final Factory m_inst = new Factory();

        private Factory() {
            super("Factory", 64);
        }

        static State getInstance() {
            return m_inst;
        }
    }

    protected static final class Registered
    extends Satisfied {
        private static final Registered m_inst = new Registered();

        private Registered() {
            super("Registered", 32);
        }

        static State getInstance() {
            return m_inst;
        }

        Object getService(ImmediateComponentManager dcm) {
            if (dcm.createComponent()) {
                dcm.changeState(Active.getInstance());
                return dcm.getInstance();
            }
            dcm.log(1, "Failed creating the component instance; see log for reason", null);
            try {
                dcm.deleteComponent(0);
            }
            catch (Throwable t) {
                dcm.log(4, "Cannot delete incomplete component instance. Ignoring.", t);
            }
            return null;
        }

        void ungetService(ImmediateComponentManager dcm) {
        }
    }

    protected static final class Active
    extends Satisfied {
        private static final Active m_inst = new Active();

        private Active() {
            super("Active", 16);
        }

        static State getInstance() {
            return m_inst;
        }

        Object getService(ImmediateComponentManager dcm) {
            return dcm.getInstance();
        }

        void ungetService(ImmediateComponentManager dcm) {
            dcm.deleteComponent(0);
            if (dcm.enabled) {
                dcm.changeState(Registered.getInstance());
            }
        }
    }

    protected static abstract class Satisfied
    extends State {
        protected Satisfied(String name, int state) {
            super(name, state);
        }

        ServiceReference getServiceReference(AbstractComponentManager acm) {
            ServiceRegistration sr = acm.getServiceRegistration();
            return sr == null ? null : sr.getReference();
        }

        void deactivate(AbstractComponentManager acm, int reason, boolean disable) {
            acm.log(4, "Deactivating component", null);
            this.doDeactivate(acm, reason, disable);
            if (acm.state().isSatisfied()) {
                acm.changeState(Unsatisfied.getInstance());
            }
            acm.log(4, "Component deactivated", null);
        }

        void disable(AbstractComponentManager acm) {
            this.doDisable(acm);
            acm.changeState(Disabled.getInstance());
            acm.log(4, "Component disabled", null);
        }

        void dispose(AbstractComponentManager acm, int reason) {
            this.doDeactivate(acm, reason, true);
            this.doDisable(acm);
            acm.clear();
            acm.changeState(Disposed.getInstance());
        }

        public boolean isSatisfied() {
            return true;
        }
    }

    protected static final class Unsatisfied
    extends State {
        private static final Unsatisfied m_inst = new Unsatisfied();

        private Unsatisfied() {
            super("Unsatisfied", 4);
        }

        static State getInstance() {
            return m_inst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean activate(AbstractComponentManager acm) {
            if (!acm.isActivatorActive()) {
                acm.log(4, "Bundle's component activator is not active; not activating component", null);
                return true;
            }
            acm.log(4, "Activating component from state ", new Object[]{this}, null);
            if (!acm.hasConfiguration() && acm.getComponentMetadata().isConfigurationRequired()) {
                acm.log(4, "Missing required configuration, cannot activate", null);
                return true;
            }
            if (!acm.hasServiceRegistrationPermissions()) {
                acm.log(4, "Component is not permitted to register all services, cannot activate", null);
                return true;
            }
            acm.log(4, "Updating target filters", null);
            acm.updateTargets(acm.getProperties());
            if (!acm.verifyDependencyManagers(acm.getProperties())) {
                acm.log(4, "Not all dependencies satisfied, cannot activate", null);
                return true;
            }
            State satisfiedState = acm.getSatisfiedState();
            acm.changeState(satisfiedState);
            acm.registerComponentService();
            if (acm.isImmediate() || acm.getComponentMetadata().isFactory()) {
                try {
                    if (!acm.collectDependencies()) {
                        acm.log(4, "Not all dependencies collected, cannot create object (1)", null);
                        return false;
                    }
                    acm.log(4, "activate won collecting dependencies, proceed to creating object.", null);
                }
                catch (IllegalStateException e) {
                    acm.log(4, "Not all dependencies collected, cannot create object (2)", null);
                    return false;
                }
                catch (Throwable t) {
                    acm.log(1, "Unexpected throwable from attempt to collect dependencies", t);
                    return false;
                }
                acm.obtainWriteLock("AbstractComponentManager.Unsatisfied.activate.1");
                try {
                    acm.changeState(acm.getActiveState());
                    if (!acm.createComponent()) {
                        acm.log(1, "Component instance could not be created, activation failed", null);
                        acm.changeState(Unsatisfied.getInstance());
                    }
                }
                finally {
                    acm.releaseWriteLock("AbstractComponentManager.Unsatisfied.activate.1");
                }
            }
            return true;
        }

        void deactivate(AbstractComponentManager acm, int reason, boolean disable) {
            acm.log(4, "Deactivating component", null);
            this.doDeactivate(acm, reason, disable);
            acm.log(4, "Component deactivated", null);
        }

        void disable(AbstractComponentManager acm) {
            acm.log(4, "Disabling component", null);
            this.doDisable(acm);
            acm.changeState(Disabled.getInstance());
            acm.log(4, "Component disabled", null);
        }

        void dispose(AbstractComponentManager acm, int reason) {
            acm.disableDependencyManagers();
            this.doDisable(acm);
            acm.clear();
            acm.changeState(Disposed.getInstance());
        }

        Object getService(ImmediateComponentManager dcm) {
            return null;
        }

        void ungetService(ImmediateComponentManager dcm) {
        }
    }

    protected static final class Disabled
    extends State {
        private static final Disabled m_inst = new Disabled();

        private Disabled() {
            super("Disabled", 1);
        }

        static State getInstance() {
            return m_inst;
        }

        void enable(AbstractComponentManager acm) {
            if (!acm.isActivatorActive()) {
                acm.log(4, "Bundle's component activator is not active; not enabling component", null);
                return;
            }
            acm.registerComponentId();
            try {
                acm.enableDependencyManagers();
                acm.changeState(Unsatisfied.getInstance());
                acm.log(4, "Component enabled", null);
            }
            catch (InvalidSyntaxException ise) {
                acm.log(1, "Failed enabling Component", ise);
                acm.disableDependencyManagers();
                acm.unregisterComponentId();
                acm.changeState(Disabled.getInstance());
            }
        }

        void deactivate(AbstractComponentManager acm, int reason, boolean disable) {
            this.doDeactivate(acm, reason, disable);
        }

        Object getService(ImmediateComponentManager dcm) {
            return null;
        }

        void ungetService(ImmediateComponentManager dcm) {
        }

        void dispose(AbstractComponentManager acm, int reason) {
            acm.log(4, "Disposing component (reason: " + reason + ")", null);
            acm.clear();
            acm.changeState(Disposed.getInstance());
            acm.log(4, "Component disposed", null);
        }
    }

    protected static abstract class State {
        private final String m_name;
        private final int m_state;

        protected State(String name, int state) {
            this.m_name = name;
            this.m_state = state;
        }

        public String toString() {
            return this.m_name;
        }

        int getState() {
            return this.m_state;
        }

        ServiceReference getServiceReference(AbstractComponentManager acm) {
            throw new IllegalStateException("getServiceReference" + this);
        }

        Object getService(ImmediateComponentManager dcm) {
            throw new IllegalStateException("getService" + this);
        }

        void ungetService(ImmediateComponentManager dcm) {
            throw new IllegalStateException("ungetService" + this);
        }

        void enable(AbstractComponentManager acm) {
            this.log(acm, "enable");
        }

        boolean activate(AbstractComponentManager acm) {
            this.log(acm, "activate");
            return false;
        }

        void deactivate(AbstractComponentManager acm, int reason, boolean disable) {
            this.log(acm, "deactivate (reason: " + reason + ") (dsable: " + disable + ")");
        }

        void disable(AbstractComponentManager acm) {
            throw new IllegalStateException("disable" + this);
        }

        void dispose(AbstractComponentManager acm, int reason) {
            throw new IllegalStateException("dispose" + this);
        }

        private void log(AbstractComponentManager acm, String event) {
            acm.log(4, "Current state: {0}, Event: {1}, Service registration: {2}", new Object[]{this.m_name, event, acm.m_serviceRegistration.get()}, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doDeactivate(AbstractComponentManager acm, int reason, boolean disable) {
            try {
                acm.unregisterComponentService();
                acm.obtainWriteLock("AbstractComponentManager.State.doDeactivate.1");
                try {
                    acm.deleteComponent(reason);
                    acm.deactivateDependencyManagers();
                    if (disable) {
                        acm.disableDependencyManagers();
                    }
                    acm.unsetDependencyMap();
                }
                finally {
                    acm.releaseWriteLock("AbstractComponentManager.State.doDeactivate.1");
                }
            }
            catch (Throwable t) {
                acm.log(2, "Component deactivation threw an exception", t);
            }
        }

        void doDisable(AbstractComponentManager acm) {
            acm.unregisterComponentId();
        }

        public boolean isSatisfied() {
            return false;
        }
    }
}

