/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.nio.charset.Charset;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineDecoder;
import org.apache.mina.filter.codec.textline.TextLineEncoder;

public class Mina2TextLineCodecFactory
implements ProtocolCodecFactory {
    private TextLineEncoder encoder;
    private TextLineDecoder decoder;

    public Mina2TextLineCodecFactory(Charset charset, LineDelimiter delimiter) {
        this.encoder = delimiter.equals((Object)LineDelimiter.AUTO) ? new TextLineEncoder(charset) : new TextLineEncoder(charset, delimiter);
        this.decoder = new TextLineDecoder(charset, delimiter);
    }

    public ProtocolEncoder getEncoder(IoSession session) throws Exception {
        return this.encoder;
    }

    public ProtocolDecoder getDecoder(IoSession session) throws Exception {
        return this.decoder;
    }

    public void setEncoderMaxLineLength(int encoderMaxLineLength) {
        this.encoder.setMaxLineLength(encoderMaxLineLength);
    }

    public int getEncoderMaxLineLength() {
        return this.encoder.getMaxLineLength();
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoder.setMaxLineLength(decoderMaxLineLength);
    }

    public int getDecoderMaxLineLength() {
        return this.decoder.getMaxLineLength();
    }
}

