/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mqtt.MQTTComponent;
import org.apache.camel.component.mqtt.MQTTConfiguration;
import org.apache.camel.component.mqtt.MQTTConsumer;
import org.apache.camel.component.mqtt.MQTTProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.Promise;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTEndpoint.class);
    private CallbackConnection connection;
    private final MQTTConfiguration configuration;
    private final List<MQTTConsumer> consumers = new CopyOnWriteArrayList<MQTTConsumer>();

    public MQTTEndpoint(String uri, MQTTComponent component, MQTTConfiguration properties) {
        super(uri, (Component)component);
        this.configuration = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MQTTConsumer answer = new MQTTConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new MQTTProducer(this);
    }

    public MQTTConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection = this.configuration.callbackConnection();
        this.connection.listener(new Listener(){

            public void onConnected() {
                LOG.info("MQTT Connection connected to {}", (Object)MQTTEndpoint.this.configuration.getHost());
            }

            public void onDisconnected() {
                LOG.debug("MQTT Connection disconnected from {}", (Object)MQTTEndpoint.this.configuration.getHost());
            }

            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
                if (!MQTTEndpoint.this.consumers.isEmpty()) {
                    Exchange exchange = MQTTEndpoint.this.createExchange();
                    exchange.getIn().setBody((Object)body.toByteArray());
                    exchange.getIn().setHeader("CamelMQTTSubscribeTopic", (Object)topic.toString());
                    for (MQTTConsumer consumer : MQTTEndpoint.this.consumers) {
                        consumer.processExchange(exchange);
                    }
                }
                if (ack != null) {
                    ack.run();
                }
            }

            public void onFailure(Throwable value) {
                MQTTEndpoint.this.connection.disconnect((Callback)new Callback<Void>(){

                    public void onSuccess(Void value) {
                    }

                    public void onFailure(Throwable e) {
                        LOG.debug("Failed to disconnect from " + MQTTEndpoint.this.configuration.getHost() + ". This exception is ignored.", e);
                    }
                });
            }
        });
        final Promise promise = new Promise();
        this.connection.connect((Callback)new Callback<Void>(){

            public void onSuccess(Void value) {
                String subscribeTopicName = MQTTEndpoint.this.configuration.getSubscribeTopicName();
                String string = subscribeTopicName = subscribeTopicName != null ? subscribeTopicName.trim() : null;
                if (subscribeTopicName != null && !subscribeTopicName.isEmpty()) {
                    Topic[] topics = new Topic[]{new Topic(subscribeTopicName, MQTTEndpoint.this.configuration.getQoS())};
                    MQTTEndpoint.this.connection.subscribe(topics, (Callback)new Callback<byte[]>(){

                        public void onSuccess(byte[] value) {
                            promise.onSuccess((Object)value);
                        }

                        public void onFailure(Throwable value) {
                            promise.onFailure(value);
                            MQTTEndpoint.this.connection.disconnect(null);
                        }
                    });
                } else {
                    promise.onSuccess((Object)value);
                }
            }

            public void onFailure(Throwable value) {
                promise.onFailure(value);
                MQTTEndpoint.this.connection.disconnect(null);
            }
        });
        promise.await((long)this.configuration.getConnectWaitInSeconds(), TimeUnit.SECONDS);
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            final Promise promise = new Promise();
            this.connection.disconnect((Callback)new Callback<Void>(){

                public void onSuccess(Void value) {
                    promise.onSuccess((Object)value);
                }

                public void onFailure(Throwable value) {
                    promise.onFailure(value);
                }
            });
            promise.await((long)this.configuration.getDisconnectWaitInSeconds(), TimeUnit.SECONDS);
        }
        super.doStop();
    }

    void publish(String topic, byte[] payload, QoS qoS, boolean retain, Callback<Void> callback) throws Exception {
        this.connection.publish(topic, payload, qoS, retain, callback);
    }

    void addConsumer(MQTTConsumer consumer) {
        this.consumers.add(consumer);
    }

    void removeConsumer(MQTTConsumer consumer) {
        this.consumers.remove((Object)consumer);
    }

    public boolean isSingleton() {
        return true;
    }
}

