/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SID
extends AbstractSegment {
    public SID(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Application / Method Identifier");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Substance Container Identifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Substance Manufacturer Identifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SID - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getApplicationMethodIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getSid1_ApplicationMethodIdentifier() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getSubstanceLotNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSid2_SubstanceLotNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSubstanceContainerIdentifier() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSid3_SubstanceContainerIdentifier() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getSubstanceManufacturerIdentifier() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getSid4_SubstanceManufacturerIdentifier() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

