/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.AbstractParser;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.FixedWidthParserUtils;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFixedLengthParser
extends AbstractParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFixedLengthParser.class);

    protected AbstractFixedLengthParser(Reader dataSourceReader, String dataDefinition) {
        super(dataSourceReader, dataDefinition);
    }

    protected AbstractFixedLengthParser(Reader dataSourceReader) {
        super(dataSourceReader);
    }

    protected DataSet doParse() {
        try {
            return this.doFixedLengthFile(this.getDataSourceReader());
        }
        catch (IOException e) {
            LOGGER.error("error accessing/reading data", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet doFixedLengthFile(Reader dataSource) throws IOException {
        BufferedReader br = null;
        DefaultDataSet ds = new DefaultDataSet(this.getPzMetaData(), this);
        try {
            ds.setPZConvertProps(ParserUtils.loadConvertProperties());
            Map<String, Integer> recordLengths = ParserUtils.calculateRecordLengths(this.getPzMetaData());
            br = new BufferedReader(dataSource);
            String line = null;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                String mdkey;
                block13: {
                    ++lineCount;
                    if (line.trim().length() == 0) continue;
                    mdkey = FixedWidthParserUtils.getCMDKey(this.getPzMetaData(), line);
                    int recordLength = recordLengths.get(mdkey);
                    if (line.length() > recordLength) {
                        if (this.isIgnoreExtraColumns()) {
                            line = line.substring(0, recordLength);
                            this.addError(ds, "TRUNCATED LINE TO CORRECT LENGTH", lineCount, 1);
                            break block13;
                        } else {
                            this.addError(ds, "LINE TOO LONG. LINE IS " + line.length() + " LONG. SHOULD BE " + recordLength, lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                    if (line.length() < recordLength) {
                        if (this.isHandlingShortLines()) {
                            line = line + ParserUtils.padding(recordLength - line.length(), ' ');
                            this.addError(ds, "PADDED LINE TO CORRECT RECORD LENGTH", lineCount, 1);
                        } else {
                            this.addError(ds, "LINE TOO SHORT. LINE IS " + line.length() + " LONG. SHOULD BE " + recordLength, lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                }
                Row row = new Row();
                row.setMdkey(mdkey.equals("detail") ? null : mdkey);
                List<ColumnMetaData> cmds = ParserUtils.getColumnMetaData(mdkey, this.getPzMetaData());
                row.addColumn(FixedWidthParserUtils.splitFixedText(cmds, line, this.isPreserveLeadingWhitespace(), this.isPreserveTrailingWhitespace()));
                row.setRowNumber(lineCount);
                if (this.isFlagEmptyRows()) {
                    row.setEmpty(ParserUtils.isListElementsEmpty(row.getCols()));
                }
                if (this.isStoreRawDataToDataSet()) {
                    row.setRawData(line);
                }
                ds.addRow(row);
            }
            return ds;
        }
        finally {
            if (br != null) {
                br.close();
            }
            this.closeReaders();
        }
    }
}

