/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.Parser;
import net.sf.flatpack.Record;
import net.sf.flatpack.RowRecord;
import net.sf.flatpack.ordering.OrderBy;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.FPException;
import net.sf.flatpack.util.FPInvalidUsageException;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDataSet
implements DataSet {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final List<Row> rows = new ArrayList<Row>();
    private final List<DataError> errors = new ArrayList<DataError>();
    private Properties pzConvertProps = null;
    private int pointer = -1;
    private boolean lowerCase = false;
    private boolean upperCase = false;
    private boolean strictNumericParse = false;
    private MetaData metaData;
    private Parser parser;
    private Record currentRecord;

    public DefaultDataSet(MetaData pzMetaData, Parser pzparser) {
        this.metaData = pzMetaData;
        this.parser = pzparser;
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addError(DataError dataError) {
        this.errors.add(dataError);
    }

    @Override
    public String[] getColumns() {
        String[] array = null;
        if (this.metaData != null) {
            List<ColumnMetaData> cmds = this.metaData.getColumnsNames();
            array = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                ColumnMetaData column = cmds.get(i);
                array[i] = column.getColName();
            }
        }
        return array;
    }

    @Override
    public String[] getColumns(String recordID) {
        String[] array = null;
        if (this.metaData != null) {
            List<ColumnMetaData> cmds = ParserUtils.getColumnMetaData(recordID, this.metaData);
            array = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                ColumnMetaData column = cmds.get(i);
                array[i] = column.getColName();
            }
        }
        return array;
    }

    @Override
    public Date getDate(String column) throws ParseException {
        return this.currentRecord.getDate(column);
    }

    @Override
    public Date getDate(String column, SimpleDateFormat sdf) throws ParseException {
        return this.currentRecord.getDate(column, sdf);
    }

    @Override
    public double getDouble(String column) {
        return this.currentRecord.getDouble(column);
    }

    @Override
    public BigDecimal getBigDecimal(String column) {
        return this.currentRecord.getBigDecimal(column);
    }

    @Override
    public Object getObject(String column, Class<?> classToConvertTo) {
        return this.currentRecord.getObject(column, classToConvertTo);
    }

    @Override
    public int getErrorCount() {
        if (this.getErrors() != null) {
            return this.getErrors().size();
        }
        return 0;
    }

    @Override
    public List getErrors() {
        return this.errors;
    }

    @Override
    public int getIndex() {
        return this.pointer;
    }

    @Override
    public int getInt(String column) {
        return this.currentRecord.getInt(column);
    }

    @Override
    public long getLong(String column) {
        return this.currentRecord.getLong(column);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getRowNo() {
        return this.currentRecord.getRowNo();
    }

    @Override
    public String getString(String column) {
        return this.currentRecord.getString(column);
    }

    @Override
    public void setValue(String column, String value) {
        Row row = this.rows.get(this.pointer);
        int colIndex = ParserUtils.getColumnIndex(row.getMdkey(), this.metaData, column, this.parser.isColumnNamesCaseSensitive());
        row.setValue(colIndex, value);
    }

    @Override
    public void goBottom() {
        this.pointer = this.rows.size() - 1;
    }

    @Override
    public void goTop() {
        this.pointer = -1;
    }

    @Override
    public boolean isAnError(int lineNo) {
        for (int i = 0; i < this.errors.size(); ++i) {
            if (this.errors.get(i).getLineNo() != lineNo || this.errors.get(i).getErrorLevel() <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() {
        if (this.pointer < this.rows.size() && this.pointer + 1 != this.rows.size()) {
            ++this.pointer;
            this.currentRecord = new RowRecord(this.rows.get(this.pointer), this.metaData, this.parser.isColumnNamesCaseSensitive(), this.pzConvertProps, this.strictNumericParse, this.upperCase, this.lowerCase, this.parser.isNullEmptyStrings());
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    @Override
    public Record getRecord() {
        return this.currentRecord;
    }

    @Override
    public void orderRows(OrderBy ob) {
        if (ob != null && this.rows != null) {
            ob.setMetaData(this.getMetaData());
            ob.setParser(this.parser);
            Collections.sort(this.rows, ob);
            this.goTop();
        }
    }

    @Override
    public boolean previous() {
        if (this.pointer <= 0) {
            this.currentRecord = null;
            return false;
        }
        --this.pointer;
        this.currentRecord = new RowRecord(this.rows.get(this.pointer), this.metaData, this.parser.isColumnNamesCaseSensitive(), this.pzConvertProps, this.strictNumericParse, this.upperCase, this.lowerCase, this.parser.isNullEmptyStrings());
        return true;
    }

    @Override
    public void setLowerCase() {
        this.upperCase = false;
        this.lowerCase = true;
    }

    @Override
    public void setUpperCase() {
        this.upperCase = true;
        this.lowerCase = false;
    }

    @Override
    public boolean isRecordID(String recordID) {
        return this.currentRecord.isRecordID(recordID);
    }

    @Override
    public void absolute(int localPointer) {
        if (localPointer < 0 || localPointer >= this.rows.size()) {
            throw new IndexOutOfBoundsException("INVALID POINTER LOCATION: " + localPointer);
        }
        this.pointer = localPointer;
        this.currentRecord = new RowRecord(this.rows.get(this.pointer), this.metaData, this.parser.isColumnNamesCaseSensitive(), this.pzConvertProps, this.strictNumericParse, this.upperCase, this.lowerCase, this.parser.isNullEmptyStrings());
    }

    @Override
    public void setStrictNumericParse(boolean strictNumericParse) {
        this.strictNumericParse = strictNumericParse;
    }

    @Override
    public void remove() {
        this.rows.remove(this.pointer);
        --this.pointer;
    }

    @Override
    public void setPZConvertProps(Properties props) {
        this.pzConvertProps = props;
    }

    protected void setPointer(int pointer) {
        this.pointer = pointer;
    }

    @Override
    public void clearRows() {
        this.pointer = -1;
        this.rows.clear();
    }

    @Override
    public void clearAll() {
        this.clearRows();
        this.clearErrors();
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Errors:").append(this.errors.size()).append(NEW_LINE);
        buf.append("Rows:").append(this.rows.size()).append(NEW_LINE);
        buf.append("Position:").append(this.pointer).append(NEW_LINE);
        buf.append("Conversion Props:").append(this.pzConvertProps).append(NEW_LINE);
        buf.append("MetaData:").append(this.metaData).append(NEW_LINE);
        return buf.toString();
    }

    @Override
    public boolean contains(String column) {
        if (this.pointer == -1) {
            throw new IndexOutOfBoundsException("dataset on invalid row. need to call next()");
        }
        return this.currentRecord.contains(column);
    }

    @Override
    public boolean isRowEmpty() {
        if (!this.parser.isFlagEmptyRows()) {
            throw new FPInvalidUsageException("Parser.isFlagEmptyRows(true) must be set before using isRowEmpty()");
        }
        if (this.pointer < 0) {
            throw new FPException("Cursor on invalid row..  Make sure next() is called and returns true");
        }
        return this.rows.get(this.pointer).isEmpty();
    }

    @Override
    public String getRawData() {
        if (!this.parser.isStoreRawDataToDataSet()) {
            throw new FPInvalidUsageException("Parser.isStoreRawDataToDataSet(true) must be set before using getRawData()");
        }
        if (this.pointer < 0) {
            throw new FPException("Cursor on invalid row.. Make sure next() is called and returns true");
        }
        return this.rows.get(this.pointer).getRawData();
    }
}

