/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PendingNode;
import org.apache.activemq.command.MessageId;

public class OrderedPendingList
implements PendingList {
    private PendingNode root = null;
    private PendingNode tail = null;
    private final Map<MessageId, PendingNode> map = new HashMap<MessageId, PendingNode>();

    @Override
    public PendingNode addMessageFirst(MessageReference message) {
        PendingNode node = new PendingNode(this, message);
        if (this.root == null) {
            this.root = node;
            this.tail = node;
        } else {
            this.root.linkBefore(node);
            this.root = node;
        }
        this.map.put(message.getMessageId(), node);
        return node;
    }

    @Override
    public PendingNode addMessageLast(MessageReference message) {
        PendingNode node = new PendingNode(this, message);
        if (this.root == null) {
            this.root = node;
        } else {
            this.tail.linkAfter(node);
        }
        this.tail = node;
        this.map.put(message.getMessageId(), node);
        return node;
    }

    @Override
    public void clear() {
        this.root = null;
        this.tail = null;
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<MessageReference> iterator() {
        return new Iterator<MessageReference>(){
            private PendingNode current = null;
            private PendingNode next = OrderedPendingList.access$000(OrderedPendingList.this);

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public MessageReference next() {
                MessageReference result = null;
                this.current = this.next;
                result = this.current.getMessage();
                this.next = (PendingNode)this.next.getNext();
                return result;
            }

            @Override
            public void remove() {
                if (this.current != null && this.current.getMessage() != null) {
                    OrderedPendingList.this.map.remove(this.current.getMessage().getMessageId());
                }
                OrderedPendingList.this.removeNode(this.current);
            }
        };
    }

    @Override
    public PendingNode remove(MessageReference message) {
        PendingNode node = null;
        if (message != null) {
            node = this.map.remove(message.getMessageId());
            this.removeNode(node);
        }
        return node;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    void removeNode(PendingNode node) {
        if (node != null) {
            this.map.remove(node.getMessage().getMessageId());
            if (this.root == node) {
                this.root = (PendingNode)node.getNext();
            }
            if (this.tail == node) {
                this.tail = (PendingNode)node.getPrevious();
            }
            node.unlink();
        }
    }

    List<PendingNode> getAsList() {
        ArrayList<PendingNode> result = new ArrayList<PendingNode>(this.size());
        for (PendingNode node = this.root; node != null; node = (PendingNode)node.getNext()) {
            result.add(node);
        }
        return result;
    }

    public String toString() {
        return "OrderedPendingList(" + System.identityHashCode(this) + ")";
    }

    @Override
    public boolean contains(MessageReference message) {
        if (message != null) {
            for (PendingNode value : this.map.values()) {
                if (!value.getMessage().equals(message)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<MessageReference> values() {
        ArrayList<MessageReference> messageReferences = new ArrayList<MessageReference>();
        Iterator<MessageReference> iterator = this.iterator();
        while (iterator.hasNext()) {
            messageReferences.add(iterator.next());
        }
        return messageReferences;
    }

    @Override
    public void addAll(PendingList pendingList) {
        if (pendingList != null) {
            for (MessageReference messageReference : pendingList) {
                this.addMessageLast(messageReference);
            }
        }
    }

    @Override
    public MessageReference get(MessageId messageId) {
        PendingNode node = this.map.get(messageId);
        if (node != null) {
            return node.getMessage();
        }
        return null;
    }

    static /* synthetic */ PendingNode access$000(OrderedPendingList x0) {
        return x0.root;
    }
}

