/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty4.ClientInitializerFactory;
import org.apache.camel.component.netty4.DefaultClientInitializerFactory;
import org.apache.camel.component.netty4.NettyCamelState;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.netty4.NettyHelper;
import org.apache.camel.component.netty4.NettyPayloadHelper;
import org.apache.camel.component.netty4.NettyWorkerPoolBuilder;
import org.apache.camel.component.netty4.SharedSingletonObjectPool;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NettyProducer.class);
    private final ChannelGroup allChannels = new DefaultChannelGroup("NettyProducer", (EventExecutor)ImmediateEventExecutor.INSTANCE);
    private CamelContext context;
    private NettyConfiguration configuration;
    private ClientInitializerFactory pipelineFactory;
    private CamelLogger noReplyLogger;
    private EventLoopGroup workerGroup;
    private ObjectPool<Channel> pool;
    private Map<Channel, NettyCamelState> nettyCamelStatesMap = new ConcurrentHashMap<Channel, NettyCamelState>();

    public NettyProducer(NettyEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint);
        this.configuration = configuration;
        this.context = this.getEndpoint().getCamelContext();
        this.noReplyLogger = new CamelLogger(LOG, configuration.getNoReplyLogLevel());
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return true;
    }

    public CamelContext getContext() {
        return this.context;
    }

    protected boolean isTcp() {
        return this.configuration.getProtocol().equalsIgnoreCase("tcp");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.getWorkerGroup() == null) {
            this.workerGroup = new NettyWorkerPoolBuilder().withWorkerCount(this.configuration.getWorkerCount()).withName("NettyClientTCPWorker").build();
        }
        if (this.configuration.isProducerPoolEnabled()) {
            GenericObjectPool.Config config = new GenericObjectPool.Config();
            config.maxActive = this.configuration.getProducerPoolMaxActive();
            config.minIdle = this.configuration.getProducerPoolMinIdle();
            config.maxIdle = this.configuration.getProducerPoolMaxIdle();
            config.testOnBorrow = true;
            config.testWhileIdle = true;
            config.timeBetweenEvictionRunsMillis = 30000L;
            config.minEvictableIdleTimeMillis = this.configuration.getProducerPoolMinEvictableIdle();
            config.whenExhaustedAction = 0;
            this.pool = new GenericObjectPool((PoolableObjectFactory)new NettyProducerPoolableObjectFactory(), config);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created NettyProducer pool[maxActive={}, minIdle={}, maxIdle={}, minEvictableIdleTimeMillis={}] -> {}", new Object[]{config.maxActive, config.minIdle, config.maxIdle, config.minEvictableIdleTimeMillis, this.pool});
            }
        } else {
            this.pool = new SharedSingletonObjectPool<Channel>(new NettyProducerPoolableObjectFactory());
            if (LOG.isDebugEnabled()) {
                LOG.info("Created NettyProducer shared singleton pool -> {}", this.pool);
            }
        }
        ClientInitializerFactory factory = this.configuration.getClientInitializerFactory();
        this.pipelineFactory = factory != null ? factory.createPipelineFactory(this) : new DefaultClientInitializerFactory(this);
        if (!this.configuration.isLazyChannelCreation()) {
            Channel channel = (Channel)this.pool.borrowObject();
            this.pool.returnObject((Object)channel);
        }
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping producer at address: {}", (Object)this.configuration.getAddress());
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
        if (this.pool != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping producer with channel pool[active={}, idle={}]", (Object)this.pool.getNumActive(), (Object)this.pool.getNumIdle());
            }
            this.pool.close();
            this.pool = null;
        }
        super.doStop();
    }

    public boolean process(final Exchange exchange, AsyncCallback callback) {
        Channel existing;
        Object body;
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            body = this.getRequestBody(exchange);
            if (body == null) {
                this.noReplyLogger.log("No payload to send for exchange: " + exchange);
                callback.done(true);
                return true;
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        if (this.getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)this.getConfiguration().getCharsetName()));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Pool[active={}, idle={}]", (Object)this.pool.getNumActive(), (Object)this.pool.getNumIdle());
        }
        try {
            existing = (Channel)this.pool.borrowObject();
            if (existing != null) {
                LOG.trace("Got channel from pool {}", (Object)existing);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        if (existing == null) {
            exchange.setException((Throwable)new CamelExchangeException("Cannot get channel from pool", exchange));
            callback.done(true);
            return true;
        }
        final Channel channel = existing;
        final NettyProducerCallback producerCallback = new NettyProducerCallback(channel, callback);
        this.putState(channel, new NettyCamelState(producerCallback, exchange));
        InetSocketAddress remoteAddress = null;
        if (!this.isTcp()) {
            remoteAddress = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        }
        NettyHelper.writeBodyAsync(LOG, channel, remoteAddress, body, exchange, new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                LOG.trace("Operation complete {}", (Object)channelFuture);
                if (!channelFuture.isSuccess()) {
                    exchange.setException(channelFuture.cause());
                    producerCallback.done(false);
                    return;
                }
                if (!NettyProducer.this.configuration.isSync()) {
                    try {
                        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
                        boolean disconnect = NettyProducer.this.getConfiguration().isDisconnect();
                        if (close != null) {
                            disconnect = close;
                        }
                        if (disconnect) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Closing channel when complete at address: {}", (Object)NettyProducer.this.getEndpoint().getConfiguration().getAddress());
                            }
                            NettyHelper.close(channel);
                        }
                    }
                    finally {
                        producerCallback.done(false);
                    }
                }
            }
        });
        return false;
    }

    protected Object getRequestBody(Exchange exchange) throws Exception {
        Object body = NettyPayloadHelper.getIn(this.getEndpoint(), exchange);
        if (body == null) {
            return null;
        }
        if (this.getConfiguration().isTextline()) {
            body = NettyHelper.getTextlineBody(body, exchange, this.getConfiguration().getDelimiter(), this.getConfiguration().isAutoAppendDelimiter());
        }
        return body;
    }

    public NettyCamelState getState(Channel channel) {
        return this.nettyCamelStatesMap.get(channel);
    }

    public void removeState(Channel channel) {
        this.nettyCamelStatesMap.remove(channel);
    }

    public void putState(Channel channel, NettyCamelState state) {
        this.nettyCamelStatesMap.put(channel, state);
    }

    protected EventLoopGroup getWorkerGroup() {
        EventLoopGroup wg = this.configuration.getWorkerGroup();
        if (wg == null) {
            wg = this.workerGroup;
        }
        return wg;
    }

    protected ChannelFuture openConnection() throws Exception {
        ChannelFuture answer;
        if (this.isTcp()) {
            Bootstrap clientBootstrap = new Bootstrap();
            clientBootstrap.channel(NioSocketChannel.class);
            clientBootstrap.group(this.getWorkerGroup());
            clientBootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.isKeepAlive());
            clientBootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.configuration.isTcpNoDelay());
            clientBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.configuration.isReuseAddress());
            clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectTimeout());
            clientBootstrap.handler((ChannelHandler)this.pipelineFactory);
            ChannelFuture answer2 = clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created new TCP client bootstrap connecting to {}:{} with options: {}", new Object[]{this.configuration.getHost(), this.configuration.getPort(), clientBootstrap});
            }
            return answer2;
        }
        Bootstrap connectionlessClientBootstrap = new Bootstrap();
        connectionlessClientBootstrap.channel(NioDatagramChannel.class);
        connectionlessClientBootstrap.group(this.getWorkerGroup());
        connectionlessClientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectTimeout());
        connectionlessClientBootstrap.option(ChannelOption.SO_BROADCAST, (Object)this.configuration.isBroadcast());
        connectionlessClientBootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.configuration.getSendBufferSize());
        connectionlessClientBootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.configuration.getReceiveBufferSize());
        connectionlessClientBootstrap.handler((ChannelHandler)this.pipelineFactory);
        if (!this.configuration.isUdpConnectionlessSending()) {
            answer = connectionlessClientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        } else {
            answer = connectionlessClientBootstrap.bind((SocketAddress)new InetSocketAddress(0));
            answer.awaitUninterruptibly();
            Channel channel = answer.channel();
            this.allChannels.add((Object)channel);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new UDP client bootstrap connecting to {}:{} with options: {}", new Object[]{this.configuration.getHost(), this.configuration.getPort(), connectionlessClientBootstrap});
        }
        return answer;
    }

    protected Channel openChannel(ChannelFuture channelFuture) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Waiting for operation to complete {} for {} millis", (Object)channelFuture, (Object)this.configuration.getConnectTimeout());
        }
        final CountDownLatch channelLatch = new CountDownLatch(1);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture cf) throws Exception {
                channelLatch.countDown();
            }
        });
        try {
            channelLatch.await(this.configuration.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new CamelException("Interrupted while waiting for connection to " + this.configuration.getAddress());
        }
        if (!channelFuture.isDone() || !channelFuture.isSuccess()) {
            ConnectException cause = new ConnectException("Cannot connect to " + this.configuration.getAddress());
            if (channelFuture.cause() != null) {
                cause.initCause(channelFuture.cause());
            }
            throw cause;
        }
        Channel answer = channelFuture.channel();
        this.allChannels.add((Object)answer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {}", (Object)this.configuration.getAddress());
        }
        return answer;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    private final class NettyProducerPoolableObjectFactory
    implements PoolableObjectFactory<Channel> {
        private NettyProducerPoolableObjectFactory() {
        }

        public Channel makeObject() throws Exception {
            ChannelFuture channelFuture = NettyProducer.this.openConnection();
            Channel answer = NettyProducer.this.openChannel(channelFuture);
            LOG.trace("Created channel: {}", (Object)answer);
            return answer;
        }

        public void destroyObject(Channel channel) throws Exception {
            LOG.trace("Destroying channel: {}", (Object)channel);
            if (channel.isOpen()) {
                NettyHelper.close(channel);
            }
            NettyProducer.this.allChannels.remove((Object)channel);
        }

        public boolean validateObject(Channel channel) {
            boolean answer = channel.isActive();
            LOG.trace("Validating channel: {} -> {}", (Object)channel, (Object)answer);
            return answer;
        }

        public void activateObject(Channel channel) throws Exception {
            LOG.trace("activateObject channel: {} -> {}", (Object)channel);
        }

        public void passivateObject(Channel channel) throws Exception {
            LOG.trace("passivateObject channel: {} -> {}", (Object)channel);
        }
    }

    private final class NettyProducerCallback
    implements AsyncCallback {
        private final Channel channel;
        private final AsyncCallback callback;

        private NettyProducerCallback(Channel channel, AsyncCallback callback) {
            this.channel = channel;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(boolean doneSync) {
            try {
                if (this.channel.isActive()) {
                    LOG.trace("Putting channel back to pool {}", (Object)this.channel);
                    NettyProducer.this.pool.returnObject((Object)this.channel);
                }
            }
            catch (Exception e) {
                LOG.warn("Error returning channel to pool {}. This exception will be ignored.", (Object)this.channel);
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

